/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryService;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class EJB3SubsystemDefaultCacheWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJB3SubsystemDefaultCacheWriteHandler SFSB_CACHE = new EJB3SubsystemDefaultCacheWriteHandler(CacheFactoryService.DEFAULT_SFSB_CACHE_SERVICE_NAME, null, null, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_CACHE);
    public static final EJB3SubsystemDefaultCacheWriteHandler SFSB_PASSIVATION_DISABLED_CACHE = new EJB3SubsystemDefaultCacheWriteHandler(CacheFactoryService.DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_SERVICE_NAME, null, null, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE);
    public static final EJB3SubsystemDefaultCacheWriteHandler CLUSTERED_SFSB_CACHE = new EJB3SubsystemDefaultCacheWriteHandler(CacheFactoryService.DEFAULT_CLUSTERED_SFSB_CACHE_SERVICE_NAME, CacheFactoryService.DEFAULT_SFSB_CACHE_SERVICE_NAME, ClusteredBackingCacheEntryStoreSourceService.getCacheFactoryClusterNameServiceName(null), (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_CLUSTERED_SFSB_CACHE);
    private final ServiceName serviceName;
    private final ServiceName defaultServiceName;
    private final ServiceName clusterNameServiceName;
    private final AttributeDefinition attribute;

    public EJB3SubsystemDefaultCacheWriteHandler(ServiceName serviceName, ServiceName defaultServiceName, ServiceName clusterServiceName, AttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
        this.serviceName = serviceName;
        this.defaultServiceName = defaultServiceName;
        this.clusterNameServiceName = clusterServiceName;
        this.attribute = attribute;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateCacheService(context, model, null);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateCacheService(context, restored, null);
    }

    void updateCacheService(OperationContext context, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName dependency;
        ModelNode cacheName = this.attribute.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (registry.getService(this.serviceName) != null) {
            context.removeService(this.serviceName);
        }
        if (this.clusterNameServiceName != null && registry.getService(this.clusterNameServiceName) != null) {
            context.removeService(this.clusterNameServiceName);
        }
        ServiceName serviceName = dependency = cacheName.isDefined() ? CacheFactoryService.getServiceName(cacheName.asString()) : this.defaultServiceName;
        if (dependency != null) {
            Object controller = this.installValueService(context, this.serviceName, CacheFactory.class, dependency);
            if (newControllers != null) {
                newControllers.add((ServiceController<?>)controller);
            }
            if (this.clusterNameServiceName != null && cacheName.isDefined()) {
                controller = this.installValueService(context, this.clusterNameServiceName, String.class, ClusteredBackingCacheEntryStoreSourceService.getCacheFactoryClusterNameServiceName(cacheName.asString()));
                if (newControllers != null) {
                    newControllers.add((ServiceController<?>)controller);
                }
            }
        }
    }

    private <T> ServiceController<T> installValueService(OperationContext context, ServiceName serviceName, Class<T> targetClass, ServiceName dependencyServiceName) {
        InjectedValue value = new InjectedValue();
        return context.getServiceTarget().addService(serviceName, (Service)new ValueService((Value)value)).addDependency(dependencyServiceName, targetClass, (Injector)value).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

