/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EJBRemotingConnectorClientMappingsEntryProviderService
implements Service<Registry.RegistryEntryProvider<String, List<ClientMapping>>> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"remoting"}).append(new String[]{"connector"}).append(new String[]{"client-mapping-entry-provider-service"});
    private final Registry.RegistryEntryProvider<String, List<ClientMapping>> registryEntryProvider = new ClientMappingEntryProvider();
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private final InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfo = new InjectedValue();

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public Registry.RegistryEntryProvider<String, List<ClientMapping>> getValue() {
        return this.registryEntryProvider;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironment;
    }

    public InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> getRemotingConnectorInfo() {
        return this.remotingConnectorInfo;
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        RemotingConnectorBindingInfoService.RemotingConnectorInfo info = (RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfo.getValue();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            String destinationAddress = info.getSocketBinding().getAddress().getHostAddress();
            try {
                clientNetworkAddress = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }

    String getNodeName() {
        return ((ServerEnvironment)this.serverEnvironment.getValue()).getNodeName();
    }

    private class ClientMappingEntryProvider
    implements Registry.RegistryEntryProvider<String, List<ClientMapping>> {
        private ClientMappingEntryProvider() {
        }

        public String getKey() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getNodeName();
        }

        public List<ClientMapping> getValue() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getClientMappings();
        }
    }
}

