/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.LocalHome;
import javax.ejb.RemoteHome;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.modules.Module;

public class HomeViewMergingProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;

    public HomeViewMergingProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (eeModuleDescription == null) {
            return;
        }
        Collection componentConfigurations = eeModuleDescription.getComponentDescriptions();
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        for (ComponentDescription componentConfiguration : componentConfigurations) {
            if (!(componentConfiguration instanceof SessionBeanComponentDescription)) continue;
            try {
                this.processComponentConfig(deploymentUnit, applicationClasses, module, deploymentReflectionIndex, (SessionBeanComponentDescription)componentConfiguration);
            }
            catch (Exception e) {
                throw EjbMessages.MESSAGES.failToMergeData(componentConfiguration.getComponentName(), e);
            }
        }
        if (this.appclient) {
            for (ComponentDescription componentDescription : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS)) {
                if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
                try {
                    this.processComponentConfig(deploymentUnit, applicationClasses, module, deploymentReflectionIndex, (SessionBeanComponentDescription)componentDescription);
                }
                catch (Exception e) {
                    throw EjbMessages.MESSAGES.failToMergeData(componentDescription.getComponentName(), e);
                }
            }
        }
    }

    private void processComponentConfig(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, Module module, DeploymentReflectionIndex deploymentReflectionIndex, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException, ClassNotFoundException {
        SessionBeanMetaData descriptorData;
        EEModuleClassDescription clazz;
        String home = null;
        String localHome = null;
        if (!MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit) && (clazz = applicationClasses.getClassByName(description.getComponentClassName())) != null) {
            ClassAnnotationInformation remoteAnnotations;
            ClassAnnotationInformation localAnnotations = clazz.getAnnotationInformation(LocalHome.class);
            if (localAnnotations != null && !localAnnotations.getClassLevelAnnotations().isEmpty()) {
                localHome = (String)localAnnotations.getClassLevelAnnotations().get(0);
                if (description.getEjbLocalView() == null) {
                    String localClassName = this.inferLocalInterfaceFromLocalHome(localHome, module, deploymentReflectionIndex, description);
                    description.addEjbLocalObjectView(localClassName);
                }
            }
            if ((remoteAnnotations = clazz.getAnnotationInformation(RemoteHome.class)) != null && !remoteAnnotations.getClassLevelAnnotations().isEmpty()) {
                home = (String)remoteAnnotations.getClassLevelAnnotations().get(0);
                if (description.getEjbRemoteView() == null) {
                    String remoteClassName = this.inferRemoteInterfaceFromHome(home, module, deploymentReflectionIndex, description);
                    description.addEjbObjectView(remoteClassName);
                }
            }
        }
        if ((descriptorData = description.getDescriptorData()) != null) {
            if (descriptorData.getHome() != null) {
                home = descriptorData.getHome();
            }
            if (descriptorData.getLocalHome() != null) {
                localHome = descriptorData.getLocalHome();
            }
        }
        if (localHome != null) {
            description.addLocalHome(localHome);
        }
        if (home != null) {
            description.addRemoteHome(home);
        }
        if (description.getEjbHomeView() != null && description.getEjbRemoteView() == null) {
            String remoteClassName = this.inferRemoteInterfaceFromHome(description.getEjbHomeView().getViewClassName(), module, deploymentReflectionIndex, description);
            description.addEjbObjectView(remoteClassName);
        }
        if (description.getEjbLocalHomeView() != null && description.getEjbLocalView() == null) {
            String localClassName = this.inferLocalInterfaceFromLocalHome(description.getEjbLocalHomeView().getViewClassName(), module, deploymentReflectionIndex, description);
            description.addEjbLocalObjectView(localClassName);
        }
    }

    private String inferRemoteInterfaceFromHome(String homeClassName, Module module, DeploymentReflectionIndex deploymentReflectionIndex, SessionBeanComponentDescription description) throws ClassNotFoundException, DeploymentUnitProcessingException {
        Class homeClass = module.getClassLoader().loadClass(homeClassName);
        ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(homeClass);
        Class<?> remote = null;
        for (Method method : index.getMethods()) {
            if (!method.getName().startsWith("create")) continue;
            if (remote != null && remote != method.getReturnType()) {
                throw EjbMessages.MESSAGES.multipleCreateMethod(homeClass);
            }
            remote = method.getReturnType();
        }
        if (remote == null) {
            throw EjbMessages.MESSAGES.couldNotDetermineRemoteInterfaceFromHome(homeClassName, description.getEJBName());
        }
        return remote.getName();
    }

    private String inferLocalInterfaceFromLocalHome(String localHomeClassName, Module module, DeploymentReflectionIndex deploymentReflectionIndex, SessionBeanComponentDescription description) throws ClassNotFoundException, DeploymentUnitProcessingException {
        Class localHomeClass = module.getClassLoader().loadClass(localHomeClassName);
        ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(localHomeClass);
        Class<?> localClass = null;
        for (Method method : index.getMethods()) {
            if (!method.getName().startsWith("create")) continue;
            if (localClass != null && localClass != method.getReturnType()) {
                throw EjbMessages.MESSAGES.multipleCreateMethod(localHomeClass);
            }
            localClass = method.getReturnType();
        }
        if (localClass == null) {
            throw EjbMessages.MESSAGES.couldNotDetermineLocalInterfaceFromLocalHome(localHomeClassName, description.getEJBName());
        }
        return localClass.getName();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

