/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.Remote;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class BusinessViewAnnotationProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;

    public BusinessViewAnnotationProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class<?> ejbClass;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        if (componentDescriptions != null) {
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
                ejbClass = this.getEjbClass(componentDescription.getComponentClassName(), (ClassLoader)moduleClassLoader);
                this.processViewAnnotations(deploymentUnit, ejbClass, (SessionBeanComponentDescription)componentDescription);
            }
        }
        if (this.appclient) {
            for (ComponentDescription componentDescription : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS)) {
                if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
                ejbClass = this.getEjbClass(componentDescription.getComponentClassName(), (ClassLoader)moduleClassLoader);
                this.processViewAnnotations(deploymentUnit, ejbClass, (SessionBeanComponentDescription)componentDescription);
            }
        }
    }

    private void processViewAnnotations(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass, SessionBeanComponentDescription sessionBeanComponentDescription) throws DeploymentUnitProcessingException {
        Collection<Class<?>> localBusinessInterfaces;
        Collection<Class<?>> remoteBusinessInterfaces = this.getRemoteBusinessInterfaces(deploymentUnit, sessionBeanClass);
        if (remoteBusinessInterfaces != null && !remoteBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addRemoteBusinessInterfaceViews(this.toString(remoteBusinessInterfaces));
        }
        if ((localBusinessInterfaces = this.getLocalBusinessInterfaces(deploymentUnit, sessionBeanClass)) != null && !localBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addLocalBusinessInterfaceViews(this.toString(localBusinessInterfaces));
        }
        if (BusinessViewAnnotationProcessor.hasNoInterfaceView(sessionBeanClass)) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (BusinessViewAnnotationProcessor.hasNoViews(sessionBeanComponentDescription)) {
            Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (potentialBusinessInterfaces.isEmpty()) {
                sessionBeanComponentDescription.addNoInterfaceView();
            } else if (potentialBusinessInterfaces.size() == 1) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(potentialBusinessInterfaces.iterator().next().getName());
            } else if (this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(this.toString(potentialBusinessInterfaces));
            }
        }
    }

    private Collection<Class<?>> getRemoteBusinessInterfaces(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Remote remoteViewAnnotation = sessionBeanClass.getAnnotation(Remote.class);
        if (remoteViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Remote.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] remoteViews = remoteViewAnnotation.value();
        if (remoteViews == null || remoteViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1 && !this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                throw EjbMessages.MESSAGES.beanWithRemoteAnnotationImplementsMoreThanOneInterface(sessionBeanClass);
            }
            return interfaces;
        }
        return Arrays.asList(remoteViews);
    }

    private Collection<Class<?>> getLocalBusinessInterfaces(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Local localViewAnnotation = sessionBeanClass.getAnnotation(Local.class);
        if (localViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Local.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] localViews = localViewAnnotation.value();
        if (localViews == null || localViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1 && !this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                throw EjbMessages.MESSAGES.beanWithLocalAnnotationImplementsMoreThanOneInterface(sessionBeanClass);
            }
            return interfaces;
        }
        return Arrays.asList(localViews);
    }

    private static Collection<Class<?>> getBusinessInterfacesFromInterfaceAnnotations(Class<?> sessionBeanClass, Class<? extends Annotation> annotation) {
        Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
        HashSet businessInterfaces = new HashSet();
        for (Class<?> iface : potentialBusinessInterfaces) {
            if (iface.getAnnotation(annotation) == null) continue;
            businessInterfaces.add(iface);
        }
        return businessInterfaces;
    }

    private static Set<Class<?>> getPotentialBusinessInterfaces(Class<?> sessionBeanClass) {
        return ViewInterfaces.getPotentialViewInterfaces(sessionBeanClass);
    }

    private static boolean hasNoInterfaceView(Class<?> sessionBeanClass) {
        return sessionBeanClass.getAnnotation(LocalBean.class) != null;
    }

    private static boolean hasNoViews(SessionBeanComponentDescription sessionBeanComponentDescription) {
        return sessionBeanComponentDescription.getViews() == null || sessionBeanComponentDescription.getViews().isEmpty();
    }

    private Class<?> getEjbClass(String className, ClassLoader cl) throws DeploymentUnitProcessingException {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private Collection<String> toString(Collection<Class<?>> classes) {
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class<?> klass : classes) {
            classNames.add(klass.getName());
        }
        return classNames;
    }

    private boolean isEjbVersionGreaterThanOrEqualTo32(DeploymentUnit deploymentUnit) {
        if (deploymentUnit == null) {
            return false;
        }
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return true;
        }
        return ejbJarMetaData.isVersionGreaterThanOrEqual(EjbJarVersion.EJB_3_2);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

