/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBClientCommonConnectionConfig;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceRegistry;
import org.xnio.OptionMap;

public class EJBClientClusterConfig
extends EJBClientCommonConnectionConfig
implements EJBClientConfiguration.ClusterConfiguration {
    private static final Logger logger = Logger.getLogger(EJBClientClusterConfig.class);
    private final EJBClientDescriptorMetaData.ClusterConfig delegate;
    private final Map<String, EJBClientConfiguration.ClusterNodeConfiguration> nodes = new HashMap<String, EJBClientConfiguration.ClusterNodeConfiguration>();
    private final ClusterNodeSelector clusterNodeSelector;

    public EJBClientClusterConfig(EJBClientDescriptorMetaData.ClusterConfig clusterConfig, ClassLoader deploymentClassLoader, ServiceRegistry serviceRegistry) {
        Properties connectionProps;
        this.delegate = clusterConfig;
        this.setConnectionTimeout(clusterConfig.getConnectTimeout());
        Properties channelProps = clusterConfig.getChannelCreationOptions();
        if (channelProps != null) {
            OptionMap channelCreationOptions = EJBClientClusterConfig.getOptionMapFromProperties(channelProps, this.getClass().getClassLoader());
            logger.debugf("Channel creation options for cluster %s are %s", (Object)clusterConfig.getClusterName(), (Object)channelCreationOptions);
            this.setChannelCreationOptions(channelCreationOptions);
        }
        if ((connectionProps = clusterConfig.getConnectionOptions()) != null) {
            OptionMap connectionCreationOptions = EJBClientClusterConfig.getOptionMapFromProperties(connectionProps, this.getClass().getClassLoader());
            logger.debugf("Connection creation options for cluster %s are %s", (Object)clusterConfig.getClusterName(), (Object)connectionCreationOptions);
            this.setConnectionCreationOptions(connectionCreationOptions);
        }
        this.setCallbackHandler(serviceRegistry, clusterConfig.getUserName(), clusterConfig.getSecurityRealm());
        String nodeSelector = clusterConfig.getNodeSelector();
        if (nodeSelector != null) {
            try {
                Class<?> nodeSelectorClass = deploymentClassLoader.loadClass(nodeSelector);
                this.clusterNodeSelector = (ClusterNodeSelector)nodeSelectorClass.newInstance();
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failureDuringLoadOfClusterNodeSelector(nodeSelector, clusterConfig.getClusterName(), e);
            }
        } else {
            this.clusterNodeSelector = null;
        }
    }

    public String getClusterName() {
        return this.delegate.getClusterName();
    }

    public long getMaximumAllowedConnectedNodes() {
        return this.delegate.getMaxAllowedConnectedNodes();
    }

    public ClusterNodeSelector getClusterNodeSelector() {
        return this.clusterNodeSelector;
    }

    public EJBClientConfiguration.ClusterNodeConfiguration getNodeConfiguration(String nodeName) {
        return this.nodes.get(nodeName);
    }

    public void addClusterNode(EJBClientConfiguration.ClusterNodeConfiguration node) {
        this.nodes.put(node.getNodeName(), node);
    }

    @Override
    public boolean isConnectEagerly() {
        return true;
    }
}

