/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.util.regex.Pattern;
import org.jboss.galleon.util.ParsingUtils;

public class FileFilter {
    private String patternString;
    private Pattern pattern;
    private boolean include;

    public void setPatternString(String patternString) {
        this.patternString = patternString;
        this.pattern = Pattern.compile(ParsingUtils.wildcardToJavaRegexp((String)patternString));
    }

    public void setInclude() {
        this.include = true;
    }

    public String getPattern() {
        return this.patternString;
    }

    public boolean matches(String filePath) {
        return this.pattern.matcher(filePath).matches();
    }

    public boolean isInclude() {
        return this.include;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFilter that = (FileFilter)o;
        return this.patternString.equals(that.patternString);
    }

    public int hashCode() {
        return this.patternString.hashCode();
    }

    public String toString() {
        return this.patternString;
    }
}

