/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.WildflyHttpContext;

final class HttpClientXmlParser {
    private static final String NS_EJB_HTTP_CLIENT = "urn:wildfly-http-client:1.0";

    HttpClientXmlParser() {
    }

    static WildflyHttpContext parseHttpContext() throws ConfigXMLParseException, IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        WildflyHttpContext.Builder builder = new WildflyHttpContext.Builder();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_EJB_HTTP_CLIENT));){
                HttpClientXmlParser.parseDocument(streamReader, builder);
                WildflyHttpContext wildflyHttpContext = builder.build();
                return wildflyHttpContext;
            }
        }
        return null;
    }

    static WildflyHttpContext.Builder parseConfig(URI uri) throws ConfigXMLParseException {
        WildflyHttpContext.Builder builder = new WildflyHttpContext.Builder();
        try (ConfigurationXMLStreamReader streamReader = ClientConfiguration.getInstance((URI)uri).readConfiguration(Collections.singleton(NS_EJB_HTTP_CLIENT));){
            HttpClientXmlParser.parseDocument(streamReader, builder);
            WildflyHttpContext.Builder builder2 = builder;
            return builder2;
        }
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader, WildflyHttpContext.Builder builder) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:wildfly-http-client:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "http-client": {
                            HttpClientXmlParser.parseRootElement(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                default: {
                    throw reader.unexpectedContent();
                }
            }
        }
    }

    private static void parseRootElement(ConfigurationXMLStreamReader reader, WildflyHttpContext.Builder builder) throws ConfigXMLParseException {
        int i = 0;
        int attributeCount = reader.getAttributeCount();
        if (i < attributeCount) {
            switch (reader.getAttributeLocalName(i)) {
                default: 
            }
            throw reader.unexpectedAttribute(i);
        }
        while (reader.hasNext()) {
            block2 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:wildfly-http-client:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "configs": {
                            HttpClientXmlParser.parseConfigsElement(reader, builder);
                            break block2;
                        }
                        case "defaults": {
                            HttpClientXmlParser.parseDefaults(reader, builder);
                            break block2;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static InetSocketAddress parseBind(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String address = null;
        int port = 0;
        block11: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "address": {
                    address = reader.getAttributeValue(i);
                    continue block11;
                }
                case "port": {
                    port = reader.getIntAttributeValue(i);
                    if (port >= 0 && port <= 65535) continue block11;
                    throw HttpClientMessages.MESSAGES.portValueOutOfRange(port);
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (address == null) {
            throw reader.missingRequiredAttribute(null, "address");
        }
        InetSocketAddress bindAddress = InetSocketAddress.createUnresolved(address, port);
        switch (reader.nextTag()) {
            case 2: {
                return bindAddress;
            }
        }
        throw reader.unexpectedElement();
    }

    private static long parseLongElement(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Long value = null;
        block9: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "value": {
                    value = reader.getLongAttributeValue(i);
                    continue block9;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (value == null) {
            throw reader.missingRequiredAttribute(null, "value");
        }
        switch (reader.nextTag()) {
            case 2: {
                return value;
            }
        }
        throw reader.unexpectedElement();
    }

    private static int parseIntElement(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Integer value = null;
        block9: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "value": {
                    value = reader.getIntAttributeValue(i);
                    continue block9;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (value == null) {
            throw reader.missingRequiredAttribute(null, "value");
        }
        switch (reader.nextTag()) {
            case 2: {
                return value;
            }
        }
        throw reader.unexpectedElement();
    }

    private static boolean parseBooleanElement(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Boolean value = null;
        block9: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "value": {
                    value = reader.getBooleanAttributeValue(i);
                    continue block9;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (value == null) {
            throw reader.missingRequiredAttribute(null, "value");
        }
        switch (reader.nextTag()) {
            case 2: {
                return value;
            }
        }
        throw reader.unexpectedElement();
    }

    private static void parseConfigsElement(ConfigurationXMLStreamReader reader, WildflyHttpContext.Builder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:wildfly-http-client:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "config": {
                            HttpClientXmlParser.parseConfig(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseDefaults(ConfigurationXMLStreamReader reader, WildflyHttpContext.Builder builder) throws ConfigXMLParseException {
        if (reader.getAttributeCount() > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:wildfly-http-client:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "bind-address": {
                            builder.setDefaultBindAddress(HttpClientXmlParser.parseBind(reader));
                            break block0;
                        }
                        case "idle-timeout": {
                            builder.setIdleTimeout(HttpClientXmlParser.parseLongElement(reader));
                            break block0;
                        }
                        case "max-connections": {
                            builder.setMaxConnections(HttpClientXmlParser.parseIntElement(reader));
                            break block0;
                        }
                        case "max-streams-per-connection": {
                            builder.setMaxStreamsPerConnection(HttpClientXmlParser.parseIntElement(reader));
                            break block0;
                        }
                        case "eagerly-acquire-session": {
                            builder.setEagerlyAcquireSession(HttpClientXmlParser.parseBooleanElement(reader));
                            break block0;
                        }
                        case "enable-http2": {
                            builder.setEnableHttp2(HttpClientXmlParser.parseBooleanElement(reader));
                            break block0;
                        }
                        case "buffer-pool": {
                            builder.setBufferConfig(HttpClientXmlParser.parseBufferConfig(reader));
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static WildflyHttpContext.BufferBuilder parseBufferConfig(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Integer bufferSize = null;
        Integer maxSize = null;
        Integer threadLocalSize = null;
        Boolean direct = null;
        block15: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "buffer-size": {
                    bufferSize = reader.getIntAttributeValue(i);
                    continue block15;
                }
                case "max-size": {
                    maxSize = reader.getIntAttributeValue(i);
                    continue block15;
                }
                case "thread-local-size": {
                    threadLocalSize = reader.getIntAttributeValue(i);
                    continue block15;
                }
                case "direct": {
                    direct = reader.getBooleanAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (bufferSize == null) {
            throw reader.missingRequiredAttribute(null, "value");
        }
        WildflyHttpContext.BufferBuilder value = new WildflyHttpContext.BufferBuilder();
        value.setBufferSize(bufferSize);
        if (maxSize != null) {
            value.setMaxSize(maxSize);
        }
        if (threadLocalSize != null) {
            value.setThreadLocalSize(threadLocalSize);
        }
        if (direct != null) {
            value.setDirect(direct);
        }
        switch (reader.nextTag()) {
            case 2: {
                return value;
            }
        }
        throw reader.unexpectedElement();
    }

    private static void parseConfig(ConfigurationXMLStreamReader reader, WildflyHttpContext.Builder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        block32: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "uri": {
                    uri = reader.getURIAttributeValue(i);
                    continue block32;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (uri == null) {
            throw reader.missingRequiredAttribute(null, "uri");
        }
        WildflyHttpContext.Builder.HttpConfigBuilder targetBuilder = builder.addConfig(uri);
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:wildfly-http-client:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "idle-timeout": {
                            targetBuilder.setIdleTimeout(HttpClientXmlParser.parseLongElement(reader));
                            break block6;
                        }
                        case "max-connections": {
                            targetBuilder.setMaxConnections(HttpClientXmlParser.parseIntElement(reader));
                            break block6;
                        }
                        case "max-streams-per-connection": {
                            targetBuilder.setMaxStreamsPerConnection(HttpClientXmlParser.parseIntElement(reader));
                            break block6;
                        }
                        case "eagerly-acquire-session": {
                            targetBuilder.setEagerlyAcquireSession(HttpClientXmlParser.parseBooleanElement(reader));
                            break block6;
                        }
                        case "enable-http2": {
                            targetBuilder.setEnableHttp2(HttpClientXmlParser.parseBooleanElement(reader));
                            break block6;
                        }
                        case "bind-address": {
                            targetBuilder.setBindAddress(HttpClientXmlParser.parseBind(reader));
                            break block6;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }
}

