/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.server.SSLSessionInfo;
import io.undertow.util.Methods;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.httpclient.common.ClientAuthUtils;
import org.wildfly.httpclient.common.HTTPTestServer;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

@RunWith(value=HTTPTestServer.class)
public class ClientSNITestCase {
    @Test
    public void testSNIWithHostname() throws Throwable {
        InetAddress address = InetAddress.getByName(HTTPTestServer.getHostAddress());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        SSLContext sslContext = HTTPTestServer.createClientSSLContext();
        String path = "/host";
        ArrayList result = new ArrayList(1);
        HTTPTestServer.registerPathHandler("/host", exchange -> {
            SSLSessionInfo ssl;
            if ("/host".equals(exchange.getRequestURI()) && (ssl = exchange.getConnection().getSslSessionInfo()) != null && ssl.getSSLSession() instanceof ExtendedSSLSession) {
                result.addAll(((ExtendedSSLSession)ssl.getSSLSession()).getRequestedServerNames());
            }
        });
        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/host");
        URI uri = new URI("https://" + address.getHostName() + ":" + HTTPTestServer.getSSLHostPort() + request.getPath());
        this.doClientRequest(request, uri, sslContext);
        ((ListAssert)Assertions.assertThat(result).as("Check sni names contains " + address.getHostName(), new Object[0])).containsExactly((Object[])new SNIServerName[]{new SNIHostName(address.getHostName())});
    }

    @Test
    public void testNoSNIWithIP() throws Throwable {
        InetAddress address = InetAddress.getByName(HTTPTestServer.getHostAddress());
        Assume.assumeTrue((String)"Assuming the test if no resolution for the address", (!address.getHostName().equals(address.getHostAddress()) ? 1 : 0) != 0);
        String hostname = address instanceof Inet6Address ? "[" + address.getHostAddress() + "]" : address.getHostAddress();
        SSLContext sslContext = HTTPTestServer.createClientSSLContext();
        String path = "/host";
        ArrayList result = new ArrayList(1);
        HTTPTestServer.registerPathHandler("/host", exchange -> {
            SSLSessionInfo ssl;
            if ("/host".equals(exchange.getRequestURI()) && (ssl = exchange.getConnection().getSslSessionInfo()) != null && ssl.getSSLSession() instanceof ExtendedSSLSession) {
                result.addAll(((ExtendedSSLSession)ssl.getSSLSession()).getRequestedServerNames());
            }
        });
        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath("/host");
        URI uri = new URI("https://" + hostname + ":" + HTTPTestServer.getSSLHostPort() + request.getPath());
        this.doClientRequest(request, uri, sslContext);
        ((ListAssert)Assertions.assertThat(result).as("Check no SNI names with IP", new Object[0])).isEmpty();
    }

    private void doClientRequest(ClientRequest request, URI uri, SSLContext sslContext) throws Throwable {
        ClientAuthUtils.setupBasicAuth(request, uri);
        CompletableFuture future = new CompletableFuture();
        HttpTargetContext context = WildflyHttpContext.getCurrent().getTargetContext(uri);
        context.sendRequest(request, sslContext, AuthenticationConfiguration.empty(), null, (result, response, doneCallback) -> future.complete(null), throwable -> future.completeExceptionally(throwable), null, null, true);
        future.get(10L, TimeUnit.SECONDS);
    }
}

