/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.httpclient.common.ClientAuthUtils;
import org.wildfly.httpclient.common.HTTPTestServer;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

@RunWith(value=HTTPTestServer.class)
public class ClientHostHeaderTestCase {
    private static final Logger log = Logger.getLogger(ClientHostHeaderTestCase.class.getName());

    @Test
    public void hostHeaderIncludesPortTest() throws URISyntaxException, InterruptedException {
        ArrayList hosts = new ArrayList();
        String path = "/host";
        HTTPTestServer.registerPathHandler(path, exchange -> hosts.add(exchange.getRequestHeaders().getFirst(Headers.HOST)));
        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
        this.doClientRequest(request);
        ((ListAssert)Assertions.assertThat(hosts).as("Check Host header includes also port", new Object[0])).containsExactly((Object[])new String[]{HTTPTestServer.getHostAddress() + ":" + HTTPTestServer.getHostPort()});
    }

    @Test
    public void hostHeaderIsNotOverridenIfProvided() throws URISyntaxException, InterruptedException {
        ArrayList hosts = new ArrayList();
        String path = "/host";
        HTTPTestServer.registerPathHandler(path, exchange -> hosts.add(exchange.getRequestHeaders().getFirst(Headers.HOST)));
        String myHostHeader = "127.0.0.2";
        ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
        request.getRequestHeaders().put(Headers.HOST, myHostHeader);
        this.doClientRequest(request);
        ((ListAssert)Assertions.assertThat(hosts).as("Check Host header includes also port", new Object[0])).containsExactly((Object[])new String[]{myHostHeader});
    }

    private void doClientRequest(ClientRequest request) throws URISyntaxException, InterruptedException {
        ClientAuthUtils.setupBasicAuth(request, new URI(HTTPTestServer.getDefaultServerURL() + request.getPath()));
        final CountDownLatch latch = new CountDownLatch(1);
        HttpTargetContext context = WildflyHttpContext.getCurrent().getTargetContext(new URI(HTTPTestServer.getDefaultServerURL()));
        context.sendRequest(request, null, AuthenticationConfiguration.empty(), null, new HttpTargetContext.HttpResultHandler(){

            public void handleResult(InputStream result, ClientResponse response, Closeable doneCallback) {
                latch.countDown();
            }
        }, new HttpTargetContext.HttpFailureHandler(){

            public void handleFailure(Throwable throwable) {
                log.log(Level.SEVERE, "Request handling failed with exception", throwable);
                latch.countDown();
            }
        }, null, null, true);
        latch.await(10L, TimeUnit.SECONDS);
    }
}

