/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.httpclient.common.PoolAuthenticationContext;

public class PoolAuthenticationContextTestCase {
    @Test
    public void testCreateTargetUriWithParams() throws URISyntaxException {
        ClientRequest request = new ClientRequest();
        request.setPath("/te%2Bst/test.html?param1=value1&param2=val%20ue2");
        Assert.assertEquals((Object)"http://localhost:8080/te%2Bst/test.html?param1=value1&param2=val%20ue2", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost:8080"), (ClientRequest)request));
        Assert.assertEquals((Object)"http://localhost/te%2Bst/test.html?param1=value1&param2=val%20ue2", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost"), (ClientRequest)request));
        Assert.assertEquals((Object)"http://localhost/te%2Bst/test.html?param1=value1&param2=val%20ue2", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost:80"), (ClientRequest)request));
        Assert.assertEquals((Object)"https://localhost/te%2Bst/test.html?param1=value1&param2=val%20ue2", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("https://localhost"), (ClientRequest)request));
        Assert.assertEquals((Object)"https://localhost/te%2Bst/test.html?param1=value1&param2=val%20ue2", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("https://localhost:443"), (ClientRequest)request));
    }

    @Test
    public void testCreateTargetUriWithoutParams() throws URISyntaxException {
        ClientRequest req = new ClientRequest();
        req.setPath("/te%2Bst/test.html");
        Assert.assertEquals((Object)"http://localhost:8080/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost:8080"), (ClientRequest)req));
        Assert.assertEquals((Object)"http://localhost/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost"), (ClientRequest)req));
        Assert.assertEquals((Object)"http://localhost/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http://localhost:80"), (ClientRequest)req));
        Assert.assertEquals((Object)"https://localhost/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("https://localhost"), (ClientRequest)req));
        Assert.assertEquals((Object)"https://localhost/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("https://localhost:443"), (ClientRequest)req));
    }

    @Test
    public void testCreateTargetUriIPv6() throws URISyntaxException {
        ClientRequest req = new ClientRequest();
        req.setPath("/te%2Bst/test.html");
        Assert.assertEquals((Object)"http://[::1]/te%2Bst/test.html", (Object)PoolAuthenticationContext.createTargetUri((URI)new URI("http", "::1", null, null), (ClientRequest)req));
    }
}

