/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.Asynchronous;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.ejb.EjbHeaders;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpEJBInvocationBuilder;
import org.wildfly.httpclient.ejb.PackedInteger;
import org.wildfly.httpclient.ejb.ProtocolV1ClassTable;
import org.wildfly.httpclient.ejb.ProtocolV1ObjectTable;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.httpclient.transaction.XidProvider;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.xnio.IoUtils;

class HttpEJBReceiver
extends EJBReceiver {
    private final io.undertow.util.AttachmentKey<EjbContextData> EJB_CONTEXT_DATA = io.undertow.util.AttachmentKey.create(EjbContextData.class);
    private final AttachmentKey<String> INVOCATION_ID = new AttachmentKey();
    private final RemoteTransactionContext transactionContext = RemoteTransactionContext.getInstance();
    private static final AtomicLong invocationIdGenerator = new AtomicLong();

    HttpEJBReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        URI uri;
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator locator = clientInvocationContext.getLocator();
        Affinity affinity = locator.getAffinity();
        if (namingProvider instanceof HttpNamingProvider) {
            uri = namingProvider.getProviderUri();
        } else if (affinity instanceof URIAffinity) {
            uri = affinity.getUri();
        } else {
            throw EjbHttpClientMessages.MESSAGES.invalidAffinity(affinity);
        }
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false);
        targetContext.getConnectionPool().getConnection(connection -> this.invocationConnectionReady(clientInvocationContext, receiverContext, connection, targetContext), e -> receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer(e, null)), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> locator) throws Exception {
        Affinity affinity = locator.getAffinity();
        if (!(affinity instanceof URIAffinity)) {
            throw EjbHttpClientMessages.MESSAGES.invalidAffinity(affinity);
        }
        URI uri = affinity.getUri();
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator((EJBLocator)locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(true);
        CompletableFuture result = new CompletableFuture();
        targetContext.getConnectionPool().getConnection(connection -> this.openSessionConnectionReady(connection, result, locator, targetContext), e -> result.completeExceptionally(new IOException(e)), false);
        return (StatefulEJBLocator)result.get();
    }

    private <T> void openSessionConnectionReady(HttpConnectionPool.ConnectionHandle connection, CompletableFuture<StatefulEJBLocator<T>> result, StatelessEJBLocator<T> locator, HttpTargetContext targetContext) throws IllegalArgumentException {
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.STATEFUL_CREATE).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setView(locator.getViewType().getName()).setBeanName(locator.getBeanName());
        ClientRequest request = builder.createRequest(connection.getUri().getPath());
        targetContext.sendRequest(connection, request, output -> {
            MarshallingConfiguration config = this.createMarshallingConfig();
            Marshaller marshaller = targetContext.createMarshaller(config);
            marshaller.start(output);
            this.writeTransaction((Transaction)ContextTransactionManager.getInstance().getTransaction(), (DataOutput)marshaller, connection.getUri());
            marshaller.finish();
        }, (unmarshaller, response) -> {
            String sessionId = response.getResponseHeaders().getFirst(EjbHeaders.EJB_SESSION_ID);
            if (sessionId == null) {
                result.completeExceptionally(EjbHttpClientMessages.MESSAGES.noSessionIdInResponse());
            } else {
                SessionID sessionID = SessionID.createSessionID((byte[])Base64.getDecoder().decode(sessionId));
                result.complete(new StatefulEJBLocator((EJBLocator)locator, sessionID));
            }
        }, result::completeExceptionally, EjbHeaders.EJB_RESPONSE_NEW_SESSION, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        URI uri;
        NamingProvider namingProvider = receiverContext.getNamingProvider();
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator locator = clientInvocationContext.getLocator();
        Affinity affinity = locator.getAffinity();
        if (namingProvider instanceof HttpNamingProvider) {
            uri = namingProvider.getProviderUri();
        } else if (affinity instanceof URIAffinity) {
            uri = affinity.getUri();
        } else {
            throw EjbHttpClientMessages.MESSAGES.invalidAffinity(affinity);
        }
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false);
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.CANCEL).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setCancelIfRunning(cancelIfRunning).setInvocationId((String)receiverContext.getClientInvocationContext().getAttachment(this.INVOCATION_ID)).setBeanName(locator.getBeanName());
        CompletableFuture result = new CompletableFuture();
        targetContext.sendRequest(builder.createRequest(targetContext.getUri().getPath()), null, (stream, response) -> {
            result.complete(true);
            IoUtils.safeClose((Closeable)stream);
        }, throwable -> result.complete(false), null, null);
        try {
            return (Boolean)result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    private void invocationConnectionReady(EJBClientInvocationContext clientInvocationContext, EJBReceiverInvocationContext receiverContext, HttpConnectionPool.ConnectionHandle connection, HttpTargetContext targetContext) {
        EjbContextData ejbData = (EjbContextData)targetContext.getAttachment(this.EJB_CONTEXT_DATA);
        EJBLocator locator = clientInvocationContext.getLocator();
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.METHOD_INVOCATION).setMethod(clientInvocationContext.getInvokedMethod()).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setView(clientInvocationContext.getViewClass().getName()).setBeanName(locator.getBeanName());
        if (locator instanceof StatefulEJBLocator) {
            builder.setBeanId(Base64.getEncoder().encodeToString(((StatefulEJBLocator)locator).getSessionId().getEncodedForm()));
        }
        if (clientInvocationContext.getInvokedMethod().getReturnType() == Future.class) {
            receiverContext.proceedAsynchronously();
            if (targetContext.getSessionId() != null) {
                long invocationId = invocationIdGenerator.incrementAndGet();
                String invocationIdString = Long.toString(invocationId);
                builder.setInvocationId(invocationIdString);
                clientInvocationContext.putAttachment(this.INVOCATION_ID, (Object)invocationIdString);
            }
        } else if (clientInvocationContext.getInvokedMethod().getReturnType() == Void.TYPE) {
            if (clientInvocationContext.getInvokedMethod().isAnnotationPresent(Asynchronous.class)) {
                receiverContext.proceedAsynchronously();
            } else if (ejbData.asyncMethods.contains(clientInvocationContext.getInvokedMethod())) {
                receiverContext.proceedAsynchronously();
            }
        }
        ClientRequest request = builder.createRequest(connection.getUri().getPath());
        request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
        targetContext.sendRequest(connection, request, marshaller -> this.marshalEJBRequest(marshaller, clientInvocationContext, targetContext), (input, response) -> {
            if (response.getResponseCode() == 202 && clientInvocationContext.getInvokedMethod().getReturnType() == Void.TYPE) {
                ejbContextData.asyncMethods.add(clientInvocationContext.getInvokedMethod());
            }
            Exception exception = null;
            Object returned = null;
            try {
                MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfig();
                Unmarshaller unmarshaller = targetContext.createUnmarshaller(marshallingConfiguration);
                unmarshaller.start((ByteInput)new InputStreamByteInput(input));
                returned = unmarshaller.readObject();
                Map<String, Object> attachments = HttpEJBReceiver.readAttachments((ObjectInput)unmarshaller);
                if (unmarshaller.read() != -1) {
                    exception = EjbHttpClientMessages.MESSAGES.unexpectedDataInResponse();
                }
                unmarshaller.finish();
                if (response.getResponseCode() >= 400) {
                    receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer((Exception)returned, null));
                    return;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            Object ret = returned;
            Exception ex = exception;
            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer(ex, ret));
        }, e -> receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer(e instanceof Exception ? (Exception)e : new RuntimeException(e), null)), EjbHeaders.EJB_RESPONSE_VERSION_ONE, null);
    }

    private MarshallingConfiguration createMarshallingConfig() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    private void marshalEJBRequest(ByteOutput byteOutput, EJBClientInvocationContext clientInvocationContext, HttpTargetContext targetContext) throws IOException, RollbackException, SystemException {
        MarshallingConfiguration config = this.createMarshallingConfig();
        Marshaller marshaller = targetContext.createMarshaller(config);
        marshaller.start(byteOutput);
        this.writeTransaction(clientInvocationContext.getTransaction(), (DataOutput)marshaller, targetContext.getUri());
        Object[] methodParams = clientInvocationContext.getParameters();
        if (methodParams != null && methodParams.length > 0) {
            for (Object methodParam : methodParams) {
                marshaller.writeObject(methodParam);
            }
        }
        Map privateAttachments = clientInvocationContext.getAttachments();
        Map contextData = clientInvocationContext.getContextData();
        int privateAttachmentsSize = privateAttachments.size() - (privateAttachments.containsKey(this.INVOCATION_ID) ? 1 : 0);
        if (contextData == null && privateAttachmentsSize == 0) {
            marshaller.writeByte(0);
        } else {
            int totalAttachments = contextData.size();
            if (privateAttachmentsSize > 0) {
                ++totalAttachments;
            }
            PackedInteger.writePackedInteger((DataOutput)marshaller, totalAttachments);
            for (Map.Entry invocationContextData : contextData.entrySet()) {
                marshaller.writeObject(invocationContextData.getKey());
                marshaller.writeObject(invocationContextData.getValue());
            }
            if (privateAttachmentsSize > 0) {
                marshaller.writeObject((Object)"org.jboss.ejb.client.invocation.attachments");
                HashMap copy = new HashMap(privateAttachments);
                copy.remove(this.INVOCATION_ID);
                marshaller.writeObject(copy);
            }
        }
        marshaller.finish();
    }

    private XAOutflowHandle writeTransaction(Transaction transaction, DataOutput dataOutput, URI uri) throws IOException, RollbackException, SystemException {
        if (transaction == null) {
            dataOutput.writeByte(0);
            return null;
        }
        if (transaction instanceof RemoteTransaction) {
            XidProvider ir = (XidProvider)((RemoteTransaction)transaction).getProviderInterface(XidProvider.class);
            if (ir == null) {
                throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
            }
            Xid xid = ir.getXid();
            dataOutput.writeByte(1);
            dataOutput.writeInt(xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeInt(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeInt(bq.length);
            dataOutput.write(bq);
            return null;
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(uri, localTransaction);
            Xid xid = outflowHandle.getXid();
            dataOutput.writeByte(2);
            dataOutput.writeInt(xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeInt(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeInt(bq.length);
            dataOutput.write(bq);
            dataOutput.writeInt(outflowHandle.getRemainingTime());
            return outflowHandle;
        }
        throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
    }

    private static Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    private static class EjbContextData {
        final Set<Method> asyncMethods = Collections.newSetFromMap(new ConcurrentHashMap());

        private EjbContextData() {
        }
    }

    private static class StaticResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Exception ex;
        private final Object ret;

        public StaticResultProducer(Exception ex, Object ret) {
            this.ex = ex;
            this.ret = ret;
        }

        public Object getResult() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            return this.ret;
        }

        public void discardResult() {
        }
    }
}

