/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.httpclient.naming.HttpRemoteContext;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.util.FastHashtable;
import org.xnio.IoUtils;

public class HttpRootContext
extends AbstractContext {
    private final String ACCEPT_VALUE = "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1";
    private final ContentType VALUE_TYPE = new ContentType("application/x-wf-jndi-jbmar-value", 1);
    private final HttpNamingProvider httpNamingProvider;
    private final String scheme;

    protected HttpRootContext(FastHashtable<String, Object> environment, HttpNamingProvider httpNamingProvider, String scheme) {
        super(environment);
        this.httpNamingProvider = httpNamingProvider;
        this.scheme = scheme;
    }

    public void bind(String name, Object obj) throws NamingException {
        super.bind(name, obj);
    }

    protected Object lookupNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/lookup/");
        return this.processInvocation(name, Methods.POST, providerUri, sb);
    }

    protected Object lookupLinkNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/lookuplink/");
        return this.processInvocation(name, Methods.POST, providerUri, sb);
    }

    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/list/");
        Collection result = (Collection)this.processInvocation(name, Methods.GET, providerUri, sb);
        return CloseableNamingEnumeration.fromIterable((Iterable)result);
    }

    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/list-bindings/");
        Collection result = (Collection)this.processInvocation(name, Methods.GET, providerUri, sb);
        return CloseableNamingEnumeration.fromIterable((Iterable)result);
    }

    protected void bindNative(Name name, Object obj) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/bind/");
        this.processInvocation(name, Methods.PUT, providerUri, obj, sb);
    }

    protected void rebindNative(Name name, Object obj) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/rebind/");
        this.processInvocation(name, Methods.PATCH, providerUri, obj, sb);
    }

    protected void unbindNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/unbind/");
        this.processInvocation(name, Methods.PUT, providerUri, sb);
    }

    protected void renameNative(Name oldName, Name newName) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/rename/");
        this.processInvocation(oldName, Methods.PATCH, providerUri, sb, newName);
    }

    protected void destroySubcontextNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/rename/");
        this.processInvocation(name, Methods.PUT, providerUri, sb);
    }

    protected Context createSubcontextNative(Name name) throws NamingException {
        URI providerUri = this.httpNamingProvider.getProviderUri();
        StringBuilder sb = new StringBuilder(providerUri.getPath());
        sb.append("/naming/v1/create-subcontext/");
        this.processInvocation(name, Methods.PUT, providerUri, null, sb);
        return new HttpRemoteContext(this, name.toString());
    }

    private MarshallingConfiguration createMarshallingConfig() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    private Object processInvocation(Name name, HttpString method, URI providerUri, StringBuilder sb) throws NamingException {
        return this.processInvocation(name, method, providerUri, sb, (Name)null);
    }

    private Object processInvocation(Name name, HttpString method, URI providerUri, StringBuilder sb, Name newName) throws NamingException {
        try {
            sb.append(URLEncoder.encode(name.toString(), StandardCharsets.UTF_8.name()));
            if (newName != null) {
                sb.append("?new=");
                sb.append(URLEncoder.encode(newName.toString(), StandardCharsets.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        String path = sb.toString();
        ClientRequest clientRequest = new ClientRequest().setPath(path).setMethod(method);
        clientRequest.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1");
        CompletableFuture result = new CompletableFuture();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(providerUri);
        targetContext.sendRequest(clientRequest, null, (input, response) -> {
            if (response.getResponseCode() == 204) {
                result.complete(new HttpRemoteContext(this, name.toString()));
                IoUtils.safeClose((Closeable)input);
                return;
            }
            Exception exception = null;
            Object returned = null;
            try {
                MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfig();
                Unmarshaller unmarshaller = targetContext.createUnmarshaller(marshallingConfiguration);
                unmarshaller.start((ByteInput)new InputStreamByteInput(input));
                returned = unmarshaller.readObject();
                if (unmarshaller.read() != -1) {
                    exception = HttpNamingClientMessages.MESSAGES.unexpectedDataInResponse();
                }
                unmarshaller.finish();
                if (response.getResponseCode() >= 400) {
                    exception = (Exception)returned;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception != null) {
                result.completeExceptionally(exception);
            } else {
                result.complete(returned);
            }
        }, result::completeExceptionally, this.VALUE_TYPE, null, true);
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    private void processInvocation(Name name, HttpString method, URI providerUri, Object object, StringBuilder sb) throws NamingException {
        try {
            sb.append(URLEncoder.encode(name.toString(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        String path = sb.toString();
        ClientRequest clientRequest = new ClientRequest().setPath(path).setMethod(method);
        clientRequest.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1");
        if (object != null) {
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, this.VALUE_TYPE.toString());
        }
        CompletableFuture result = new CompletableFuture();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(providerUri);
        targetContext.sendRequest(clientRequest, output -> {
            if (object != null) {
                Marshaller marshaller = targetContext.createMarshaller(this.createMarshallingConfig());
                marshaller.start(output);
                marshaller.writeObject(object);
                marshaller.finish();
            }
            output.close();
        }, (input, response) -> result.complete(null), result::completeExceptionally, null, null);
        try {
            result.get();
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }
}

