/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpServerExchange;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;

public final class HttpNamingServerObjectResolver
implements ObjectResolver {
    private URIAffinity selfNodeAffinity;

    public HttpNamingServerObjectResolver(HttpServerExchange exchange) {
        try {
            this.selfNodeAffinity = this.createLocalURIAffinity(exchange);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private URIAffinity createLocalURIAffinity(HttpServerExchange exchange) throws URISyntaxException {
        StringBuilder uriStringBuilder = new StringBuilder();
        uriStringBuilder.append(exchange.getRequestScheme()).append("://").append(exchange.getHostAndPort()).append("/wildfly-services");
        return new URIAffinity(new URI(uriStringBuilder.toString()));
    }

    public Object readResolve(Object replacement) {
        return replacement;
    }

    public Object writeReplace(Object original) {
        if (original == Affinity.LOCAL && this.selfNodeAffinity != null) {
            return this.selfNodeAffinity;
        }
        return original;
    }
}

