/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jberet.spi.BatchEnvironment;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentFactory {
    private final ConcurrentMap<ClassLoader, BatchEnvironment> environments = new ConcurrentHashMap<ClassLoader, BatchEnvironment>();

    public static BatchEnvironmentFactory getInstance() {
        return Holder.INSTANCE;
    }

    public BatchEnvironment getBatchEnvironment() {
        return this.getBatchEnvironment(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }

    public BatchEnvironment getBatchEnvironment(ClassLoader cl) {
        return (BatchEnvironment)this.environments.get(cl);
    }

    public void add(BatchEnvironment batchEnvironment) {
        this.add(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), batchEnvironment);
    }

    public void add(ClassLoader cl, BatchEnvironment batchEnvironment) {
        this.environments.putIfAbsent(cl, batchEnvironment);
    }

    public BatchEnvironment remove() {
        return this.remove(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }

    public BatchEnvironment remove(ClassLoader cl) {
        return (BatchEnvironment)this.environments.remove(cl);
    }

    private static class Holder {
        static final BatchEnvironmentFactory INSTANCE = new BatchEnvironmentFactory();

        private Holder() {
        }
    }
}

