/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet.services;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.ThreadContextSetup;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.jberet.BatchEnvironmentFactory;
import org.wildfly.jberet.WildFlyArtifactFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentService
implements Service<BatchEnvironment> {
    private final InjectedValue<ClassLoader> classLoaderInjector = new InjectedValue();
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceInjector = new InjectedValue();
    private final InjectedValue<Properties> propertiesInjector = new InjectedValue();
    private final InjectedValue<UserTransaction> userTransactionInjector = new InjectedValue();
    private final InjectedEENamespaceContextSelector namespaceContextSelector;
    private volatile BatchEnvironment batchEnvironment;

    public BatchEnvironmentService(InjectedEENamespaceContextSelector namespaceContextSelector) {
        this.namespaceContextSelector = namespaceContextSelector;
    }

    public void start(StartContext context) throws StartException {
        WildFlyBatchEnvironment batchEnvironment = new WildFlyBatchEnvironment((ClassLoader)this.classLoaderInjector.getOptionalValue(), (BeanManager)this.beanManagerInjector.getOptionalValue(), (ExecutorService)this.executorServiceInjector.getValue(), (UserTransaction)this.userTransactionInjector.getValue(), (Properties)this.propertiesInjector.getValue(), this.namespaceContextSelector);
        BatchEnvironmentFactory.getInstance().add((ClassLoader)this.classLoaderInjector.getValue(), batchEnvironment);
        this.batchEnvironment = batchEnvironment;
    }

    public void stop(StopContext context) {
        if (this.batchEnvironment != null) {
            BatchEnvironmentFactory.getInstance().remove(this.batchEnvironment.getClassLoader());
        }
        this.batchEnvironment = null;
    }

    public BatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public InjectedValue<ClassLoader> getClassLoaderInjector() {
        return this.classLoaderInjector;
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceInjector;
    }

    public InjectedValue<Properties> getPropertiesInjector() {
        return this.propertiesInjector;
    }

    public InjectedValue<UserTransaction> getUserTransactionInjector() {
        return this.userTransactionInjector;
    }

    private static class ClassLoaderThreadContextSetup
    implements ThreadContextSetup {
        private final ClassLoader classLoader;

        public ClassLoaderThreadContextSetup(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ThreadContextSetup.TearDownHandle setup() {
            final ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            return new ThreadContextSetup.TearDownHandle(){

                public void tearDown() {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                }
            };
        }
    }

    private static class WildFlyBatchEnvironment
    implements BatchEnvironment {
        private final ArtifactFactory artifactFactory;
        private final ExecutorService executorService;
        private final UserTransaction userTransaction;
        private final Properties properties;
        private final ClassLoader classLoader;
        private final ThreadContextSetup threadContextSetup;
        private final InjectedEENamespaceContextSelector namespaceContextSelector;

        WildFlyBatchEnvironment(ClassLoader classLoader, BeanManager beanManager, ExecutorService executorService, UserTransaction userTransaction, Properties properties, InjectedEENamespaceContextSelector namespaceContextSelector) {
            this.classLoader = classLoader;
            this.artifactFactory = new WildFlyArtifactFactory(beanManager);
            this.executorService = executorService;
            this.userTransaction = userTransaction;
            this.properties = properties;
            this.threadContextSetup = new ClassLoaderThreadContextSetup(classLoader);
            this.namespaceContextSelector = namespaceContextSelector;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            return this.artifactFactory;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public UserTransaction getUserTransaction() {
            return this.userTransaction;
        }

        public Properties getBatchConfigurationProperties() {
            return this.properties;
        }

        public ThreadContextSetup getThreadContextSetup() {
            return this.threadContextSetup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T lookup(String name) throws NamingException {
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.namespaceContextSelector);
            try {
                Object t = InitialContext.doLookup(name);
                return t;
            }
            finally {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
    }
}

