/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.tm.TxUtils;

public class TransactionUtil {
    private static volatile TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private static volatile TransactionManager transactionManager;

    public static void setTransactionManager(TransactionManager tm) {
        if (transactionManager == null) {
            transactionManager = tm;
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        if (TransactionUtil.transactionSynchronizationRegistry == null) {
            TransactionUtil.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        }
    }

    public static boolean isInTx() {
        Transaction tx = TransactionUtil.getTransaction();
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public static EntityManager getTransactionScopedEntityManager(String puScopedName) {
        return TransactionUtil.getEntityManagerInTransactionRegistry(puScopedName);
    }

    public static void registerSynchronization(EntityManager entityManager, String puScopedName) {
        TransactionUtil.getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)new SessionSynchronization(entityManager, puScopedName));
    }

    public static Transaction getTransaction() {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw JpaLogger.ROOT_LOGGER.errorGettingTransaction((Exception)((Object)e));
        }
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return transactionSynchronizationRegistry;
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    public static String getEntityManagerDetails(EntityManager manager, String scopedPuName) {
        String result = TransactionUtil.currentThread() + ":";
        result = manager instanceof ExtendedEntityManager ? result + manager.toString() : result + "transaction scoped EntityManager [" + scopedPuName + "]";
        return result;
    }

    private static EntityManager getEntityManagerInTransactionRegistry(String scopedPuName) {
        return (EntityManager)TransactionUtil.getTransactionSynchronizationRegistry().getResource((Object)scopedPuName);
    }

    public static void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager) {
        TransactionUtil.getTransactionSynchronizationRegistry().putResource((Object)scopedPuName, (Object)entityManager);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private String scopedPuName;

        public SessionSynchronization(EntityManager session, String scopedPuName) {
            this.manager = session;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            block4: {
                if (this.safeToClose(status)) {
                    try {
                        if (JpaLogger.ROOT_LOGGER.isDebugEnabled()) {
                            JpaLogger.ROOT_LOGGER.debugf("%s: closing entity managersession", TransactionUtil.getEntityManagerDetails(this.manager, this.scopedPuName));
                        }
                        this.manager.close();
                    }
                    catch (Exception ignored) {
                        if (!JpaLogger.ROOT_LOGGER.isDebugEnabled()) break block4;
                        JpaLogger.ROOT_LOGGER.debugf(ignored, "ignoring error that occurred while closing EntityManager for %s (", this.scopedPuName);
                    }
                }
            }
        }

        private boolean safeToClose(int status) {
            if (3 != status) {
                return !TxUtils.isTransactionManagerTimeoutThread();
            }
            return true;
        }
    }
}

