/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.puparser.PersistenceUnitXmlParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.vfs.VirtualFile;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceUnitParseProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_PERSISTENCE_XML = "WEB-INF/classes/META-INF/persistence.xml";
    private static final String META_INF_PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String LIB_FOLDER = "lib";
    private final boolean appClientContainerMode;

    public PersistenceUnitParseProcessor(boolean appclient) {
        this.appClientContainerMode = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        this.handleWarDeployment(phaseContext);
        this.handleEarDeployment(phaseContext);
        this.handleJarDeployment(phaseContext);
        phaseContext.addDeploymentDependency(TransactionManagerService.SERVICE_NAME, JpaAttachments.TRANSACTION_MANAGER);
        phaseContext.addDeploymentDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, JpaAttachments.TRANSACTION_SYNCHRONIZATION_REGISTRY);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void handleJarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!(PersistenceUnitParseProcessor.isEarDeployment(deploymentUnit) || PersistenceUnitParseProcessor.isWarDeployment(deploymentUnit) || this.appClientContainerMode && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit))) {
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.markDU(holder, deploymentUnit);
            JpaLogger.ROOT_LOGGER.tracef("parsed persistence unit definitions for jar %s", deploymentRoot.getRootName());
            this.incrementPersistenceUnitCount(deploymentUnit, holder.getPersistenceUnits().size());
            this.addApplicationDependenciesOnProvider(deploymentUnit, holder);
        }
    }

    private void handleWarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!this.appClientContainerMode && PersistenceUnitParseProcessor.isWarDeployment(deploymentUnit)) {
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(WEB_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.addApplicationDependenciesOnProvider(deploymentUnit, holder);
            this.markDU(holder, deploymentUnit);
            int puCount = holder.getPersistenceUnits().size();
            List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(JAR_FILE_EXTENSION)) continue;
                listPUHolders = new ArrayList(1);
                persistence_xml = resourceRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
                this.parse(persistence_xml, listPUHolders, deploymentUnit);
                holder = this.normalize(listPUHolders);
                resourceRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
                this.addApplicationDependenciesOnProvider(deploymentUnit, holder);
                this.markDU(holder, deploymentUnit);
                puCount += holder.getPersistenceUnits().size();
            }
            JpaLogger.ROOT_LOGGER.tracef("parsed persistence unit definitions for war %s", deploymentRoot.getRootName());
            this.incrementPersistenceUnitCount(deploymentUnit, puCount);
        }
    }

    private void handleEarDeployment(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PersistenceUnitParseProcessor.isEarDeployment(deploymentUnit)) {
            int puCount = 0;
            ArrayList<PersistenceUnitMetadataHolder> listPUHolders = new ArrayList<PersistenceUnitMetadataHolder>(1);
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile persistence_xml = deploymentRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
            this.parse(persistence_xml, listPUHolders, deploymentUnit);
            PersistenceUnitMetadataHolder holder = this.normalize(listPUHolders);
            deploymentRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
            this.addApplicationDependenciesOnProvider(deploymentUnit, holder);
            this.markDU(holder, deploymentUnit);
            puCount = holder.getPersistenceUnits().size();
            List resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot) || !resourceRoot.getRoot().getName().toLowerCase(Locale.ENGLISH).endsWith(JAR_FILE_EXTENSION) || !resourceRoot.getRoot().getParent().getName().equals(LIB_FOLDER)) continue;
                listPUHolders = new ArrayList(1);
                persistence_xml = resourceRoot.getRoot().getChild(META_INF_PERSISTENCE_XML);
                this.parse(persistence_xml, listPUHolders, deploymentUnit);
                holder = this.normalize(listPUHolders);
                resourceRoot.putAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS, (Object)holder);
                this.addApplicationDependenciesOnProvider(deploymentUnit, holder);
                this.markDU(holder, deploymentUnit);
                puCount += holder.getPersistenceUnits().size();
            }
            JpaLogger.ROOT_LOGGER.tracef("parsed persistence unit definitions for ear %s", deploymentRoot.getRootName());
            this.incrementPersistenceUnitCount(deploymentUnit, puCount);
        }
    }

    private void parse(VirtualFile persistence_xml, List<PersistenceUnitMetadataHolder> listPUHolders, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        JpaLogger.ROOT_LOGGER.tracef("parse checking if %s exists, result = %b", persistence_xml.toString(), persistence_xml.exists());
        if (persistence_xml.exists() && persistence_xml.isFile()) {
            InputStream is = null;
            try {
                is = persistence_xml.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXMLResolver.create());
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                PersistenceUnitMetadataHolder puHolder = PersistenceUnitXmlParser.parse(xmlReader, SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit));
                this.postParseSteps(persistence_xml, puHolder, deploymentUnit);
                listPUHolders.add(puHolder);
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException(JpaLogger.ROOT_LOGGER.failedToParse(persistence_xml), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void postParseSteps(VirtualFile persistence_xml, PersistenceUnitMetadataHolder puHolder, DeploymentUnit deploymentUnit) {
        for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
            ArrayList<URL> jarfilesUrls = new ArrayList<URL>();
            if (pu.getJarFiles() != null) {
                for (String jar : pu.getJarFiles()) {
                    jarfilesUrls.add(PersistenceUnitParseProcessor.getRelativeURL(persistence_xml, jar));
                }
            }
            pu.setJarFileUrls(jarfilesUrls);
            URL url = this.getPersistenceUnitURL(persistence_xml);
            pu.setPersistenceUnitRootUrl(url);
            String scopedPersistenceUnitName = Configuration.getScopedPersistenceUnitName(pu);
            if (scopedPersistenceUnitName == null) {
                scopedPersistenceUnitName = PersistenceUnitParseProcessor.createBeanName(deploymentUnit, pu.getPersistenceUnitName());
            } else {
                JpaLogger.ROOT_LOGGER.tracef("persistence unit '%s' specified a custom scoped persistence unit name hint (jboss.as.jpa.scopedname=%s).  The specified name *must* be unique across all application server deployments.", pu.getPersistenceUnitName(), scopedPersistenceUnitName);
                if (scopedPersistenceUnitName.indexOf(47) != -1) {
                    throw JpaLogger.ROOT_LOGGER.invalidScopedName(scopedPersistenceUnitName, '/');
                }
            }
            pu.setScopedPersistenceUnitName(scopedPersistenceUnitName);
        }
    }

    private static URL getRelativeURL(VirtualFile persistence_xml, String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                VirtualFile deploymentUnitFile = persistence_xml;
                VirtualFile parent = deploymentUnitFile.getParent().getParent().getParent();
                VirtualFile baseDir = parent != null ? parent : deploymentUnitFile;
                VirtualFile jarFile = baseDir.getChild(jar);
                if (jarFile == null) {
                    throw JpaLogger.ROOT_LOGGER.childNotFound(jar, baseDir);
                }
                return jarFile.toURL();
            }
            catch (Exception e1) {
                throw JpaLogger.ROOT_LOGGER.relativePathNotFound(e1, jar);
            }
        }
    }

    private URL getPersistenceUnitURL(VirtualFile persistence_xml) {
        try {
            VirtualFile metaData = persistence_xml;
            return metaData.getParent().getParent().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PersistenceUnitMetadataHolder normalize(List<PersistenceUnitMetadataHolder> listPUHolders) {
        HashMap<String, PersistenceUnitMetadata> flattened = new HashMap<String, PersistenceUnitMetadata>();
        for (PersistenceUnitMetadataHolder puHolder : listPUHolders) {
            for (PersistenceUnitMetadata pu : puHolder.getPersistenceUnits()) {
                if (!flattened.containsKey(pu.getPersistenceUnitName())) {
                    flattened.put(pu.getPersistenceUnitName(), pu);
                    continue;
                }
                PersistenceUnitMetadata first = (PersistenceUnitMetadata)flattened.get(pu.getPersistenceUnitName());
                PersistenceUnitMetadata duplicate = pu;
                JpaLogger.ROOT_LOGGER.duplicatePersistenceUnitDefinition(duplicate.getPersistenceUnitName(), first.getScopedPersistenceUnitName(), duplicate.getScopedPersistenceUnitName());
            }
        }
        PersistenceUnitMetadataHolder holder = new PersistenceUnitMetadataHolder(new ArrayList<PersistenceUnitMetadata>(flattened.values()));
        return holder;
    }

    static boolean isEarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context);
    }

    static boolean isWarDeployment(DeploymentUnit context) {
        return DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)context);
    }

    private static String getScopedDeploymentUnitPath(DeploymentUnit deploymentUnit) {
        ArrayList<String> parts = new ArrayList<String>();
        do {
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            DeploymentUnit parentdeploymentUnit = deploymentUnit.getParent();
            if (parentdeploymentUnit != null) {
                ResourceRoot parentDeploymentRoot = (ResourceRoot)parentdeploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                parts.add(0, deploymentRoot.getRoot().getPathNameRelativeTo(parentDeploymentRoot.getRoot()));
                continue;
            }
            parts.add(0, deploymentRoot.getRoot().getName());
        } while ((deploymentUnit = deploymentUnit.getParent()) != null);
        StringBuilder result = new StringBuilder();
        boolean needSeparator = false;
        for (String part : parts) {
            if (needSeparator) {
                result.append('/');
            }
            result.append(part);
            needSeparator = true;
        }
        return result.toString();
    }

    public static String createBeanName(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        if (persistenceUnitName.indexOf(47) != -1) {
            throw JpaLogger.ROOT_LOGGER.invalidPersistenceUnitName(persistenceUnitName, '/');
        }
        if (persistenceUnitName.indexOf(35) != -1) {
            throw JpaLogger.ROOT_LOGGER.invalidPersistenceUnitName(persistenceUnitName, '#');
        }
        String unitName = PersistenceUnitParseProcessor.getScopedDeploymentUnitPath(deploymentUnit) + "#" + persistenceUnitName;
        return unitName;
    }

    private void markDU(PersistenceUnitMetadataHolder holder, DeploymentUnit deploymentUnit) {
        if (holder.getPersistenceUnits() != null && holder.getPersistenceUnits().size() > 0) {
            JPADeploymentMarker.mark((DeploymentUnit)deploymentUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementPersistenceUnitCount(DeploymentUnit topDeploymentUnit, int persistenceUnitCount) {
        DeploymentUnit deploymentUnit = topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)topDeploymentUnit);
        synchronized (deploymentUnit) {
            PersistenceUnitsInApplication persistenceUnitsInApplication = this.getPersistenceUnitsInApplication(topDeploymentUnit);
            persistenceUnitsInApplication.increment(persistenceUnitCount);
        }
        JpaLogger.ROOT_LOGGER.tracef("incrementing PU count for %s by %d", topDeploymentUnit.getName(), persistenceUnitCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplicationDependenciesOnProvider(DeploymentUnit topDeploymentUnit, PersistenceUnitMetadataHolder holder) {
        DeploymentUnit deploymentUnit = topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)topDeploymentUnit);
        synchronized (deploymentUnit) {
            PersistenceUnitsInApplication persistenceUnitsInApplication = this.getPersistenceUnitsInApplication(topDeploymentUnit);
            persistenceUnitsInApplication.addPersistenceUnitHolder(holder);
        }
    }

    private PersistenceUnitsInApplication getPersistenceUnitsInApplication(DeploymentUnit topDeploymentUnit) {
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)topDeploymentUnit.getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        if (persistenceUnitsInApplication == null) {
            persistenceUnitsInApplication = new PersistenceUnitsInApplication();
            topDeploymentUnit.putAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION, (Object)persistenceUnitsInApplication);
        }
        return persistenceUnitsInApplication;
    }
}

