/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.List;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class HibernateSearchProcessor
implements DeploymentUnitProcessor {
    private static final DotName SEARCH_INDEXED_ANNOTATION_NAME = DotName.createSimple((String)"org.hibernate.search.annotations.Indexed");
    private static final ModuleIdentifier defaultSearchModule = Boolean.getBoolean("ee8.preview.mode") ? ModuleIdentifier.fromString((String)"org.hibernate.search.orm:5.10") : ModuleIdentifier.fromString((String)"org.hibernate.search.orm:main");
    private static final String NONE = "none";
    private static final String IGNORE = "auto";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            this.addSearchDependency(moduleSpecification, moduleLoader, deploymentUnit);
        }
    }

    private void addSearchDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        String searchModuleName = null;
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String providerModule = pu.getProperties().getProperty("wildfly.jpa.hibernate.search.module");
                if (providerModule == null) continue;
                if (searchModuleName == null) {
                    searchModuleName = providerModule;
                    continue;
                }
                if (providerModule.equals(searchModuleName)) continue;
                throw JpaLogger.ROOT_LOGGER.differentSearchModuleDependencies(deploymentUnit.getName(), searchModuleName, providerModule);
            }
        }
        if (NONE.equals(searchModuleName)) {
            JpaLogger.ROOT_LOGGER.debugf("Not adding Hibernate Search dependency to deployment %s", deploymentUnit.getName());
            return;
        }
        if (searchModuleName != null && !IGNORE.equals(searchModuleName)) {
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString(searchModuleName);
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, true, true, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        } else {
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List annotations = index.getAnnotations(SEARCH_INDEXED_ANNOTATION_NAME);
            if (annotations != null && annotations.size() > 0) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, defaultSearchModule, false, true, true, false));
                JpaLogger.ROOT_LOGGER.debugf("deployment %s contains %s annotation, added %s dependency", deploymentUnit.getName(), SEARCH_INDEXED_ANNOTATION_NAME, defaultSearchModule);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

