/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.modules.ClassTransformer;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

class JPADelegatingClassFileTransformer
implements ClassTransformer {
    private final PersistenceUnitMetadata persistenceUnitMetadata;

    public JPADelegatingClassFileTransformer(PersistenceUnitMetadata pu) {
        this.persistenceUnitMetadata = pu;
    }

    public ByteBuffer transform(final ClassLoader classLoader, final String className, final ProtectionDomain protectionDomain, final ByteBuffer classBytes) throws IllegalArgumentException {
        AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
        PrivilegedAction<ByteBuffer> privilegedAction = new PrivilegedAction<ByteBuffer>(){

            @Override
            public ByteBuffer run() {
                byte[] transformedBuffer = JPADelegatingClassFileTransformer.this.getBytes(classBytes);
                boolean transformed = false;
                for (javax.persistence.spi.ClassTransformer transformer : JPADelegatingClassFileTransformer.this.persistenceUnitMetadata.getTransformers()) {
                    byte[] result;
                    if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                        JpaLogger.ROOT_LOGGER.tracef("rewrite entity class '%s' using transformer '%s' for '%s'", className, transformer.getClass().getName(), JPADelegatingClassFileTransformer.this.persistenceUnitMetadata.getScopedPersistenceUnitName());
                    }
                    try {
                        result = transformer.transform(classLoader, className, null, protectionDomain, transformedBuffer);
                    }
                    catch (Exception e) {
                        throw JpaLogger.ROOT_LOGGER.invalidClassFormat(e, className);
                    }
                    if (result == null) continue;
                    transformedBuffer = result;
                    transformed = true;
                    if (!JpaLogger.ROOT_LOGGER.isTraceEnabled()) continue;
                    JpaLogger.ROOT_LOGGER.tracef("entity class '%s' was rewritten", className);
                }
                return transformed ? ByteBuffer.wrap(transformedBuffer) : null;
            }
        };
        return (ByteBuffer)WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
    }

    private byte[] getBytes(ByteBuffer classBytes) {
        byte[] bytes;
        if (classBytes == null) {
            return null;
        }
        int position = classBytes.position();
        int limit = classBytes.limit();
        if (classBytes.hasArray() && classBytes.arrayOffset() == 0 && position == 0 && limit == classBytes.capacity()) {
            bytes = classBytes.array();
        } else {
            bytes = new byte[limit - position];
            classBytes.get(bytes);
            classBytes.position(position);
        }
        return bytes;
    }
}

