/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.SynchronizationType;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.config.JPADeploymentSettings;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.CreatedEntityManagers;
import org.jboss.as.jpa.container.EntityManagerUnwrappedTargetInvocationHandler;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.container.ExtendedPersistenceDeepInheritance;
import org.jboss.as.jpa.container.ExtendedPersistenceShallowInheritance;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.messages.JpaMessages;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceContextInjectionSource
extends InjectionSource {
    private final PersistenceContextType type;
    private final PersistenceContextJndiInjectable injectable;
    private final ServiceName puServiceName;

    public PersistenceContextInjectionSource(PersistenceContextType type, SynchronizationType synchronizationType, Map properties, ServiceName puServiceName, DeploymentUnit deploymentUnit, String scopedPuName, String injectionTypeName, PersistenceUnitMetadata pu) {
        this.type = type;
        this.injectable = new PersistenceContextJndiInjectable(puServiceName, deploymentUnit, this.type, synchronizationType, properties, scopedPuName, injectionTypeName, pu);
        this.puServiceName = puServiceName;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        serviceBuilder.addDependencies(new ServiceName[]{this.puServiceName});
        injector.inject((Object)this.injectable);
    }

    public boolean equals(Object other) {
        if (other instanceof PersistenceContextInjectionSource) {
            PersistenceContextInjectionSource source = (PersistenceContextInjectionSource)((Object)other);
            return source.puServiceName.equals(this.puServiceName);
        }
        return false;
    }

    public int hashCode() {
        return this.puServiceName.hashCode();
    }

    private static final class PersistenceContextJndiInjectable
    implements ManagedReferenceFactory {
        private final ServiceName puServiceName;
        private final DeploymentUnit deploymentUnit;
        private final PersistenceContextType type;
        private final SynchronizationType synchronizationType;
        private final Map properties;
        private final String unitName;
        private final String injectionTypeName;
        private final PersistenceUnitMetadata pu;
        private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";

        public PersistenceContextJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, PersistenceContextType type, SynchronizationType synchronizationType, Map properties, String unitName, String injectionTypeName, PersistenceUnitMetadata pu) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.type = type;
            this.properties = properties;
            this.unitName = unitName;
            this.injectionTypeName = injectionTypeName;
            this.pu = pu;
            this.synchronizationType = synchronizationType;
        }

        public ManagedReference getReference() {
            AbstractEntityManager entityManager;
            PersistenceUnitServiceImpl service = (PersistenceUnitServiceImpl)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            boolean standardEntityManager = ENTITY_MANAGER_CLASS.equals(this.injectionTypeName);
            if (this.type.equals((Object)PersistenceContextType.TRANSACTION)) {
                entityManager = new TransactionScopedEntityManager(this.unitName, this.properties, emf, this.synchronizationType);
                if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                    JpaLogger.JPA_LOGGER.debugf("created new TransactionScopedEntityManager for unit name=%s", this.unitName);
                }
            } else {
                boolean useDeepInheritance = !ExtendedPersistenceInheritance.SHALLOW.equals((Object)JPAService.getDefaultExtendedPersistenceInheritance());
                JPADeploymentSettings jpaDeploymentSettings = (JPADeploymentSettings)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)this.deploymentUnit).getAttachment(JpaAttachments.DEPLOYMENT_SETTINGS_KEY);
                if (jpaDeploymentSettings != null) {
                    useDeepInheritance = ExtendedPersistenceInheritance.DEEP.equals((Object)jpaDeploymentSettings.getExtendedPersistenceInheritanceType());
                }
                boolean createdNewExtendedPersistence = false;
                ExtendedEntityManager entityManager1 = useDeepInheritance ? ExtendedPersistenceDeepInheritance.INSTANCE.findExtendedPersistenceContext(this.unitName) : ExtendedPersistenceShallowInheritance.INSTANCE.findExtendedPersistenceContext(this.unitName);
                if (entityManager1 == null) {
                    entityManager1 = new ExtendedEntityManager(this.unitName, emf.createEntityManager(this.properties));
                    createdNewExtendedPersistence = true;
                    if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                        JpaLogger.JPA_LOGGER.debugf("created new ExtendedEntityManager for unit name=%s, useDeepInheritance = %b", this.unitName, useDeepInheritance);
                    }
                } else {
                    entityManager1.increaseReferenceCount();
                    if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                        JpaLogger.JPA_LOGGER.debugf("inherited existing ExtendedEntityManager from SFSB invocation stack, unit name=%s, %d beans sharing ExtendedEntityManager, useDeepInheritance = %b", this.unitName, entityManager1.getReferenceCount(), useDeepInheritance);
                    }
                }
                entityManager = entityManager1;
                CreatedEntityManagers.registerPersistenceContext(entityManager1);
                if (createdNewExtendedPersistence) {
                    if (useDeepInheritance) {
                        ExtendedPersistenceDeepInheritance.INSTANCE.registerExtendedPersistenceContext(this.unitName, entityManager1);
                    } else {
                        ExtendedPersistenceShallowInheritance.INSTANCE.registerExtendedPersistenceContext(this.unitName, entityManager1);
                    }
                }
            }
            if (!standardEntityManager) {
                Class<?> extensionClass;
                try {
                    extensionClass = this.pu.getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw JpaMessages.MESSAGES.cannotLoadFromJpa(e, this.injectionTypeName);
                }
                Object targetValueToInject = entityManager.unwrap(extensionClass);
                Class<?>[] targetInterfaces = targetValueToInject.getClass().getInterfaces();
                Class[] proxyInterfaces = new Class[targetInterfaces.length + 1];
                boolean alreadyHasInterfaceClass = false;
                for (int interfaceIndex = 0; interfaceIndex < targetInterfaces.length; ++interfaceIndex) {
                    Class<?> interfaceClass = targetInterfaces[interfaceIndex];
                    if (interfaceClass.equals(extensionClass)) {
                        proxyInterfaces = targetInterfaces;
                        alreadyHasInterfaceClass = true;
                        break;
                    }
                    proxyInterfaces[1 + interfaceIndex] = interfaceClass;
                }
                if (!alreadyHasInterfaceClass) {
                    proxyInterfaces[0] = extensionClass;
                }
                EntityManagerUnwrappedTargetInvocationHandler entityManagerUnwrappedTargetInvocationHandler = new EntityManagerUnwrappedTargetInvocationHandler(entityManager, extensionClass);
                Object proxyForUnwrappedObject = Proxy.newProxyInstance(extensionClass.getClassLoader(), proxyInterfaces, (InvocationHandler)entityManagerUnwrappedTargetInvocationHandler);
                if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                    JpaLogger.JPA_LOGGER.debugf("injecting entity manager into a '%s' (unit name=%s)", extensionClass.getName(), this.unitName);
                }
                return new ValueManagedReference((Value)new ImmediateValue(proxyForUnwrappedObject));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)entityManager));
        }
    }
}

