/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SynchronizationType;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.NonTxEmCloser;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.messages.JpaMessages;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;

public class TransactionScopedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 455498112L;
    private final String puScopedName;
    private final Map properties;
    private transient EntityManagerFactory emf;
    private transient boolean isJPA21 = true;
    private final SynchronizationType synchronizationType;

    public TransactionScopedEntityManager(String puScopedName, Map properties, EntityManagerFactory emf, SynchronizationType synchronizationType) {
        this.puScopedName = puScopedName;
        this.properties = properties;
        this.emf = emf;
        this.synchronizationType = synchronizationType;
    }

    @Override
    protected EntityManager getEntityManager() {
        EntityManager entityManager;
        boolean isInTx = TransactionUtil.isInTx();
        if (isInTx) {
            entityManager = this.getOrCreateTransactionScopedEntityManager(this.emf, this.puScopedName, this.properties, this.synchronizationType);
        } else {
            entityManager = NonTxEmCloser.get(this.puScopedName);
            if (entityManager == null) {
                entityManager = this.createEntityManager(this.emf, this.properties, this.synchronizationType);
                NonTxEmCloser.add(this.puScopedName, entityManager);
            }
        }
        return entityManager;
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return false;
    }

    @Override
    protected boolean isInTx() {
        return TransactionUtil.isInTx();
    }

    @Override
    public void close() {
        throw JpaMessages.MESSAGES.cannotCloseTransactionContainerEntityManger();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ServiceController controller = TransactionScopedEntityManager.currentServiceContainer().getService(JPAServiceNames.getPUServiceName((String)this.puScopedName));
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)controller.getService();
        this.emf = persistenceUnitService.getEntityManagerFactory();
        this.isJPA21 = true;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    @Override
    public SynchronizationType getSynchronizationType() {
        return this.synchronizationType;
    }

    private EntityManager getOrCreateTransactionScopedEntityManager(EntityManagerFactory emf, String scopedPuName, Map properties, SynchronizationType synchronizationType) {
        EntityManager entityManager = TransactionUtil.getTransactionScopedEntityManager(this.puScopedName);
        if (entityManager == null) {
            entityManager = this.createEntityManager(emf, properties, synchronizationType);
            if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                JpaLogger.JPA_LOGGER.debugf("%s: created entity manager session %s", TransactionUtil.getEntityManagerDetails(entityManager), TransactionUtil.getTransaction().toString());
            }
            TransactionUtil.registerSynchronization(entityManager, scopedPuName);
            TransactionUtil.putEntityManagerInTransactionRegistry(scopedPuName, entityManager);
        } else {
            TransactionScopedEntityManager.testForMixedSyncronizationTypes(entityManager, this.puScopedName, synchronizationType);
            if (JpaLogger.JPA_LOGGER.isDebugEnabled()) {
                JpaLogger.JPA_LOGGER.debugf("%s: reuse entity manager session already in tx %s", TransactionUtil.getEntityManagerDetails(entityManager), TransactionUtil.getTransaction().toString());
            }
        }
        return entityManager;
    }

    private EntityManager createEntityManager(EntityManagerFactory emf, Map properties, SynchronizationType synchronizationType) {
        if (this.isJPA21()) {
            try {
                return emf.createEntityManager(synchronizationType, properties);
            }
            catch (AbstractMethodError consideredNotJPA21Exception) {
                this.setJPA21(false);
            }
        }
        if (properties != null && properties.size() > 0) {
            return emf.createEntityManager(properties);
        }
        return emf.createEntityManager();
    }

    private boolean isJPA21() {
        return this.isJPA21;
    }

    private void setJPA21(boolean value) {
        this.isJPA21 = value;
    }

    private static void testForMixedSyncronizationTypes(EntityManager entityManager, String scopedPuName, SynchronizationType targetSynchronizationType) {
        if (SynchronizationType.SYNCHRONIZED.equals((Object)targetSynchronizationType) && entityManager instanceof AbstractEntityManager && SynchronizationType.UNSYNCHRONIZED.equals((Object)((AbstractEntityManager)entityManager).getSynchronizationType())) {
            throw JpaMessages.MESSAGES.badSynchronizationTypeCombination(scopedPuName);
        }
    }
}

