/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.SynchronizationType;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.ExtendedEntityManagerKey;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class ExtendedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 432438L;
    private EntityManager underlyingEntityManager;
    private String puScopedName;
    private transient boolean isInTx;
    private int referenceCount = 1;
    private final ExtendedEntityManagerKey ID = ExtendedEntityManagerKey.extendedEntityManagerID();
    private final transient boolean isTraceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();
    private final SynchronizationType synchronizationType;

    public ExtendedEntityManager(String puScopedName, EntityManager underlyingEntityManager, SynchronizationType synchronizationType) {
        this.underlyingEntityManager = underlyingEntityManager;
        this.puScopedName = puScopedName;
        this.synchronizationType = synchronizationType;
    }

    @Override
    protected EntityManager getEntityManager() {
        this.internalAssociateWithJtaTx();
        return this.underlyingEntityManager;
    }

    public void internalAssociateWithJtaTx() {
        this.isInTx = TransactionUtil.isInTx();
        if (this.isInTx) {
            EntityManager existing = TransactionUtil.getTransactionScopedEntityManager(this.puScopedName);
            if (existing != null && existing != this) {
                throw JpaLogger.ROOT_LOGGER.cannotUseExtendedPersistenceTransaction(this.puScopedName, existing, this);
            }
            if (existing == null) {
                if (SynchronizationType.SYNCHRONIZED.equals((Object)this.synchronizationType)) {
                    this.underlyingEntityManager.joinTransaction();
                }
                TransactionUtil.putEntityManagerInTransactionRegistry(this.puScopedName, this);
            }
        }
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return true;
    }

    @Override
    protected boolean isInTx() {
        return this.isInTx;
    }

    @Override
    public void close() {
        throw JpaLogger.ROOT_LOGGER.cannotCloseContainerManagedEntityManager();
    }

    public synchronized void increaseReferenceCount() {
        ++this.referenceCount;
    }

    public synchronized int getReferenceCount() {
        return this.referenceCount;
    }

    public synchronized void refCountedClose() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            if (this.underlyingEntityManager.isOpen()) {
                this.underlyingEntityManager.close();
                if (this.isTraceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("closed extended persistence context (%s)", this.puScopedName);
                }
            }
        } else if (this.isTraceEnabled) {
            JpaLogger.ROOT_LOGGER.tracef("decremented extended persistence context (%s) owner count to %d", this.puScopedName, this.referenceCount);
        }
        if (this.referenceCount < 0) {
            throw JpaLogger.ROOT_LOGGER.referenceCountedEntityManagerNegativeCount(this.referenceCount, this.getScopedPuName());
        }
    }

    public String toString() {
        return "ExtendedEntityManager [" + this.puScopedName + "]";
    }

    public String getScopedPuName() {
        return this.puScopedName;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtendedEntityManager that = (ExtendedEntityManager)otherObject;
        return this.ID.equals(that.ID);
    }

    public int hashCode() {
        return this.ID != null ? this.ID.hashCode() : 0;
    }

    @Override
    public SynchronizationType getSynchronizationType() {
        return SynchronizationType.SYNCHRONIZED;
    }

    @Override
    protected boolean deferEntityDetachUntilClose() {
        return false;
    }
}

