/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.persistenceprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.security.manager.WildFlySecurityManager;

public class PersistenceProviderResolverImpl
implements PersistenceProviderResolver {
    private Map<ClassLoader, List<Class<? extends PersistenceProvider>>> persistenceProviderPerClassLoader = new HashMap<ClassLoader, List<Class<? extends PersistenceProvider>>>();
    private List<Class<? extends PersistenceProvider>> providers = new CopyOnWriteArrayList<Class<? extends PersistenceProvider>>();
    private static final PersistenceProviderResolverImpl INSTANCE = new PersistenceProviderResolverImpl();

    public static PersistenceProviderResolverImpl getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistenceProvider> getPersistenceProviders() {
        ArrayList<PersistenceProvider> providersCopy = new ArrayList<PersistenceProvider>(this.providers.size());
        Map<ClassLoader, List<Class<? extends PersistenceProvider>>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            if (this.persistenceProviderPerClassLoader.size() > 0) {
                ClassLoader deploymentClassLoader = this.findParentModuleCl(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
                JpaLogger.ROOT_LOGGER.tracef("get application level Persistence Provider for classloader %s", deploymentClassLoader);
                List<Class<? extends PersistenceProvider>> deploymentSpecificPersistenceProviders = this.persistenceProviderPerClassLoader.get(deploymentClassLoader);
                JpaLogger.ROOT_LOGGER.tracef("got application level Persistence Provider list %s", deploymentSpecificPersistenceProviders);
                if (deploymentSpecificPersistenceProviders != null) {
                    for (Class<? extends PersistenceProvider> providerClass : deploymentSpecificPersistenceProviders) {
                        try {
                            JpaLogger.ROOT_LOGGER.tracef("application has its own Persistence Provider %s", providerClass.getName());
                            providersCopy.add(providerClass.newInstance());
                        }
                        catch (InstantiationException e) {
                            throw JpaLogger.ROOT_LOGGER.couldNotCreateInstanceProvider(e, providerClass.getName());
                        }
                        catch (IllegalAccessException e) {
                            throw JpaLogger.ROOT_LOGGER.couldNotCreateInstanceProvider(e, providerClass.getName());
                        }
                    }
                }
            }
        }
        for (Class<? extends PersistenceProvider> providerClass : this.providers) {
            try {
                providersCopy.add(providerClass.newInstance());
                JpaLogger.ROOT_LOGGER.tracef("returning global (module) Persistence Provider %s", providerClass.getName());
            }
            catch (InstantiationException e) {
                throw JpaLogger.ROOT_LOGGER.couldNotCreateInstanceProvider(e, providerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw JpaLogger.ROOT_LOGGER.couldNotCreateInstanceProvider(e, providerClass.getName());
            }
        }
        return providersCopy;
    }

    public void clearCachedProviders() {
        this.providers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedDeploymentSpecificProviders(Set<ClassLoader> deploymentClassLoaders) {
        Map<ClassLoader, List<Class<? extends PersistenceProvider>>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            for (ClassLoader deploymentClassLoader : deploymentClassLoaders) {
                this.persistenceProviderPerClassLoader.remove(deploymentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentSpecificPersistenceProvider(PersistenceProvider persistenceProvider, Set<ClassLoader> deploymentClassLoaders) {
        Map<ClassLoader, List<Class<? extends PersistenceProvider>>> map = this.persistenceProviderPerClassLoader;
        synchronized (map) {
            for (ClassLoader deploymentClassLoader : deploymentClassLoaders) {
                List<Class<? extends PersistenceProvider>> list = this.persistenceProviderPerClassLoader.get(deploymentClassLoader);
                JpaLogger.ROOT_LOGGER.tracef("getting persistence provider list (%s) for deployment (%s)", list, deploymentClassLoader);
                if (list == null) {
                    list = new ArrayList<Class<? extends PersistenceProvider>>();
                    this.persistenceProviderPerClassLoader.put(deploymentClassLoader, list);
                    JpaLogger.ROOT_LOGGER.tracef("saving new persistence provider list (%s) for deployment (%s)", list, deploymentClassLoader);
                }
                list.add(persistenceProvider.getClass());
                JpaLogger.ROOT_LOGGER.tracef("added new persistence provider (%s) to provider list (%s)", persistenceProvider.getClass().getName(), list);
            }
        }
    }

    private ClassLoader findParentModuleCl(ClassLoader classLoader) {
        ClassLoader c;
        for (c = classLoader; c != null && !(c instanceof ModuleClassLoader); c = c.getParent()) {
        }
        return c;
    }

    public void addPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.providers.add(persistenceProvider.getClass());
    }
}

