/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp;

import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.wildfly.extension.mcp.McpEndpointConfigurationProviderRegistrar;
import org.wildfly.extension.mcp.deployment.McpServerCDIProcessor;
import org.wildfly.extension.mcp.deployment.McpServerDependencyProcessor;
import org.wildfly.extension.mcp.deployment.McpServerDeploymentProcessor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;

class MCPSubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar {
    static final String NAME = "mcp";
    static final PathElement PATH = SubsystemResourceDefinitionRegistrar.pathElement((String)"mcp");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("mcp", MCPSubsystemRegistrar.class);
    private static final int PHASE_DEPENDENCIES_MCP = 6464;
    private static final int PHASE_POST_MODULE_MCP = 14400;
    private static final int PHASE_INSTALL_MCP = 8324;

    MCPSubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        parent.setHostCapable();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)PATH), (ResourceDescriptionResolver)RESOLVER).build());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).withDeploymentChainContributor(target -> {
            target.addDeploymentProcessor(NAME, Phase.DEPENDENCIES, 6464, (DeploymentUnitProcessor)new McpServerDependencyProcessor());
            target.addDeploymentProcessor(NAME, Phase.POST_MODULE, 14400, (DeploymentUnitProcessor)new McpServerCDIProcessor());
            target.addDeploymentProcessor(NAME, Phase.INSTALL, 8324, (DeploymentUnitProcessor)new McpServerDeploymentProcessor());
        })).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new McpEndpointConfigurationProviderRegistrar(RESOLVER).register(registration, context);
        return registration;
    }
}

