/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp;

import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mcp.Capabilities;
import org.wildfly.extension.mcp.McpEndpointConfiguration;
import org.wildfly.extension.mcp.McpEndpointConfigurationProviderRegistrar;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class McpEndpointConfigurationProviderServiceConfigurator
implements ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String ssePath = McpEndpointConfigurationProviderRegistrar.SSE_PATH.resolveModelAttribute(context, model).asString("sse");
        final String messagesPath = McpEndpointConfigurationProviderRegistrar.MESSAGES_PATH.resolveModelAttribute(context, model).asString("messages");
        Supplier<McpEndpointConfiguration> factory = new Supplier<McpEndpointConfiguration>(){

            @Override
            public McpEndpointConfiguration get() {
                return new McpEndpointConfiguration(ssePath, messagesPath);
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(Capabilities.MCP_SERVER_PROVIDER_CAPABILITY, (Supplier)factory).asActive()).build();
    }
}

