/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.deployment;

import jakarta.enterprise.inject.spi.Extension;
import java.util.Optional;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.deployment.MCPAttachements;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.injection.tool.McpPortableExtension;

public class McpServerCDIProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WildFlyMCPRegistry registry = (WildFlyMCPRegistry)deploymentUnit.getAttachment(MCPAttachements.MCP_REGISTRY_METADATA);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        Optional weldCapability = support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        if (weldCapability != null && weldCapability.isPresent() && !((WeldCapability)weldCapability.get()).isPartOfWeldDeployment(deploymentUnit)) {
            MCPLogger.ROOT_LOGGER.cdiRequired();
        } else {
            ((WeldCapability)weldCapability.get()).registerExtensionInstance((Extension)new McpPortableExtension(registry, (ClassLoader)classLoader), deploymentUnit);
        }
    }
}

