/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.deployment;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.mcp.Capabilities;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.McpEndpointConfiguration;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.deployment.MCPAttachements;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.server.McpServerSentConnectionCallBack;
import org.wildfly.extension.mcp.server.MessagesHttpHandler;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.Host;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class McpSseHandlerServiceInstaller
implements DeploymentServiceInstaller {
    public void install(DeploymentPhaseContext context) {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        ModelNode model = ((DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubsystemModel("undertow");
        WildFlyMCPRegistry registry = (WildFlyMCPRegistry)deploymentUnit.getAttachment(MCPAttachements.MCP_REGISTRY_METADATA);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        String serverName = model.get(DeploymentDefinition.SERVER.getName()).asString();
        String hostName = model.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
        String webContext = model.get(DeploymentDefinition.CONTEXT_ROOT.getName()).asString();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        McpEndpointConfiguration configuration = (McpEndpointConfiguration)deploymentUnit.getAttachment(MCPAttachements.MCP_ENDPOINT_CONFIGURATION);
        final String messagesEndpoint = "/".equals(webContext) ? webContext + configuration.getMessagesPath() : webContext + "/" + configuration.getMessagesPath();
        ConnectionManager connectionManager = new ConnectionManager();
        final McpServerSentConnectionCallBack mcpServerSentConnectionCallBack = new McpServerSentConnectionCallBack(messagesEndpoint, connectionManager);
        final MessagesHttpHandler messagesHttpHandler = new MessagesHttpHandler(connectionManager, registry, (ClassLoader)classLoader, serverName, deploymentUnit.getName());
        final String ssePath = "/".equals(webContext) ? webContext + configuration.getSsePath() : webContext + "/" + configuration.getSsePath();
        Runnable start = new Runnable(){

            @Override
            public void run() {
                ((Host)host.get()).registerHandler(ssePath, (HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)mcpServerSentConnectionCallBack));
                ((Host)host.get()).registerHandler(messagesEndpoint, (HttpHandler)messagesHttpHandler);
                MCPLogger.ROOT_LOGGER.endpointRegistered(ssePath, ((Host)host.get()).getName());
            }
        };
        Runnable stop = new Runnable(){

            @Override
            public void run() {
                ((Host)host.get()).unregisterHandler(ssePath);
                ((Host)host.get()).unregisterHandler(messagesEndpoint);
                MCPLogger.ROOT_LOGGER.endpointUnregistered(ssePath, ((Host)host.get()).getName());
            }
        };
        ((ServiceInstaller)((ServiceInstaller.Builder)((ServiceInstaller.Builder)ServiceInstaller.builder((Runnable)start, (Runnable)stop).requires(List.of(host, ServiceDependency.on(Capabilities.MCP_SERVER_PROVIDER_DESCRIPTOR)))).asActive()).build()).install(context);
    }
}

