/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mcp.server;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.extension.mcp.MCPLogger;
import org.wildfly.extension.mcp.api.ClientCapability;
import org.wildfly.extension.mcp.api.ConnectionManager;
import org.wildfly.extension.mcp.api.Implementation;
import org.wildfly.extension.mcp.api.InitializeRequest;
import org.wildfly.extension.mcp.api.JsonRPC;
import org.wildfly.extension.mcp.api.McpConnection;
import org.wildfly.extension.mcp.api.Messages;
import org.wildfly.extension.mcp.api.Responder;
import org.wildfly.extension.mcp.injection.WildFlyMCPRegistry;
import org.wildfly.extension.mcp.server.PromptMessageHandler;
import org.wildfly.extension.mcp.server.ResourceMessageHandler;
import org.wildfly.extension.mcp.server.ToolMessageHandler;

public class McpMessageHandler {
    private final ConnectionManager connectionManager;
    private final Map<String, Object> serverInfo;
    private final ToolMessageHandler toolHandler;
    private final PromptMessageHandler promptHandler;
    private final ResourceMessageHandler resourceHandler;
    static final String INITIALIZE = "initialize";
    static final String NOTIFICATIONS_INITIALIZED = "notifications/initialized";
    static final String NOTIFICATIONS_MESSAGE = "notifications/message";
    static final String NOTIFICATIONS_CANCEL = "notifications/cancelled";
    static final String PROMPTS_LIST = "prompts/list";
    static final String PROMPTS_GET = "prompts/get";
    static final String TOOLS_LIST = "tools/list";
    static final String TOOLS_CALL = "tools/call";
    static final String RESOURCES_LIST = "resources/list";
    static final String RESOURCE_TEMPLATES_LIST = "resources/templates/list";
    static final String RESOURCES_READ = "resources/read";
    static final String PING = "ping";
    static final String COMPLETION_COMPLETE = "completion/complete";
    static final String LOGGING_SET_LEVEL = "logging/setLevel";
    static final String Q_CLOSE = "q/close";

    public McpMessageHandler(ConnectionManager connectionManager, WildFlyMCPRegistry registry, ClassLoader classLoader, String serverName, String serverVersion) {
        this.toolHandler = new ToolMessageHandler(registry, classLoader);
        this.promptHandler = new PromptMessageHandler(registry, classLoader);
        this.resourceHandler = new ResourceMessageHandler(registry, classLoader);
        this.connectionManager = connectionManager;
        this.serverInfo = new HashMap<String, Object>();
        this.serverInfo.put("serverInfo", Map.of("name", serverName, "version", serverVersion));
        this.serverInfo.put("protocolVersion", "2024-11-05");
        HashMap capabilities = new HashMap();
        capabilities.put("prompts", Map.of());
        capabilities.put("tools", Map.of());
        capabilities.put("resources", Map.of());
        capabilities.put("logging", Map.of());
        this.serverInfo.put("capabilities", capabilities);
    }

    public void handle(JsonObject message, McpConnection connection, Responder responder) {
        if (Messages.isResponse(message)) {
            MCPLogger.ROOT_LOGGER.warnf("Discard client response: %s", message);
        } else {
            switch (connection.status()) {
                case NEW: {
                    this.initializeNew(message, responder, connection);
                    break;
                }
                case INITIALIZING: {
                    this.initializing(message, responder, connection);
                    break;
                }
                case IN_OPERATION: {
                    this.operation(message, responder, connection);
                    break;
                }
                case SHUTDOWN: {
                    responder.send(Messages.newError(((JsonValue)message.get((Object)"id")).toString(), -32603, "Connection was already shut down"));
                }
            }
        }
    }

    private void initializeNew(JsonObject message, Responder responder, McpConnection connection) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        String method = message.getString("method");
        if (!INITIALIZE.equals(method)) {
            responder.sendError(id, -32601, "The first message from the client must be \"initialize\": " + method);
            return;
        }
        JsonObject params = message.getJsonObject("params");
        if (params == null) {
            responder.sendError(id, -32602, "Initialization params not found");
            return;
        }
        if (connection.initialize(this.decodeInitializeRequest(params))) {
            responder.sendResult(id, JsonRPC.convertMap(this.serverInfo));
        } else {
            responder.sendError(id, -32603, "Unable to initialize connection [connectionId: " + connection.id() + "]");
        }
    }

    private void initializing(JsonObject message, Responder responder, McpConnection connection) {
        String method = message.getString("method");
        if (NOTIFICATIONS_INITIALIZED.equals(method)) {
            if (connection.setInitialized()) {
                MCPLogger.ROOT_LOGGER.infof("Client successfully initialized [%s]", connection.id());
            }
        } else if (PING.equals(method)) {
            this.ping(message, responder);
        } else {
            responder.send(Messages.newError(((JsonValue)message.get((Object)"id")).toString(), -32603, "Client not initialized yet [" + connection.id() + "]"));
        }
    }

    private void operation(JsonObject message, Responder responder, McpConnection connection) {
        String method = message.get((Object)"method") == null ? "" : message.getString("method");
        String id = message.get((Object)"id") != null ? ((JsonValue)message.get((Object)"id")).toString() : "";
        switch (method) {
            case "prompts/list": {
                this.promptHandler.promptsList(message, responder);
                break;
            }
            case "prompts/get": {
                this.promptHandler.promptsGet(message, responder, connection);
                break;
            }
            case "tools/list": {
                this.toolHandler.toolsList(message, responder);
                break;
            }
            case "tools/call": {
                this.toolHandler.toolsCall(message, responder, connection);
                break;
            }
            case "notifications/cancelled": {
                connection.cancel();
                break;
            }
            case "ping": {
                this.ping(message, responder);
                break;
            }
            case "resources/list": {
                this.resourceHandler.resourcesList(message, responder);
                break;
            }
            case "resources/read": {
                this.resourceHandler.resourceCall(message, responder, connection);
                break;
            }
            case "q/close": {
                this.close(message, responder, connection);
                break;
            }
            default: {
                responder.send(Messages.newError(id, -32601, "Unsupported method: " + method));
            }
        }
    }

    private void complete(JsonObject message, Responder responder, McpConnection connection) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        JsonObject params = message.getJsonObject("params");
        JsonObject ref = params.getJsonObject("ref");
        if (ref == null) {
            responder.sendError(id, -32600, "Reference not found");
        } else {
            String referenceType = ref.getString("type");
            if (referenceType == null) {
                responder.sendError(id, -32600, "Reference type not found");
            } else {
                JsonObject argument = params.getJsonObject("argument");
                if (argument == null) {
                    responder.sendError(id, -32600, "Argument not found");
                } else if (!"ref/prompt".equals(referenceType) && !"ref/resource".equals(referenceType)) {
                    responder.sendError(id, -32600, "Unsupported reference found: " + ref.getString("type"));
                }
            }
        }
    }

    private void ping(JsonObject message, Responder responder) {
        String id = ((JsonValue)message.get((Object)"id")).toString();
        MCPLogger.ROOT_LOGGER.infof("Ping [id: %s]", id);
        responder.sendResult(id, Json.createObjectBuilder());
    }

    private void close(JsonObject message, Responder responder, McpConnection connection) {
        if (this.connectionManager.remove(connection.id())) {
            MCPLogger.ROOT_LOGGER.debugf("Connection %s closed", connection.id());
        } else {
            responder.sendError(((JsonValue)message.get((Object)"id")).toString(), -32603, "Unable to obtain the connection to be closed:" + connection.id());
        }
    }

    private InitializeRequest decodeInitializeRequest(JsonObject params) {
        JsonObject clientInfo = params.getJsonObject("clientInfo");
        Implementation implementation = new Implementation(clientInfo.getString("name"), clientInfo.getString("version"));
        String protocolVersion = params.getString("protocolVersion");
        ArrayList<ClientCapability> clientCapabilities = new ArrayList<ClientCapability>();
        JsonObject capabilities = params.getJsonObject("capabilities");
        if (capabilities != null) {
            for (String name : capabilities.keySet()) {
                clientCapabilities.add(new ClientCapability(name, Map.of()));
            }
        }
        return new InitializeRequest(implementation, protocolVersion, clientCapabilities);
    }
}

