/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DivertDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class DivertAdd
extends AbstractAddStepHandler {
    public static final DivertAdd INSTANCE = new DivertAdd(DivertDefinition.ATTRIBUTES);

    private DivertAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            if (service.getState() != ServiceController.State.UP) {
                throw MessagingLogger.ROOT_LOGGER.invalidServiceState(serviceName, ServiceController.State.UP, service.getState());
            }
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            DivertConfiguration divertConfiguration = DivertAdd.createDivertConfiguration(context, name, model);
            ActiveMQServerControlImpl serverControl = ((ActiveMQServer)ActiveMQServer.class.cast(service.getValue())).getActiveMQServerControl();
            DivertAdd.createDivert(name, divertConfiguration, (ActiveMQServerControl)serverControl);
        }
    }

    static DivertConfiguration createDivertConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        ModelNode routingNode = DivertDefinition.ROUTING_NAME.resolveModelAttribute(context, model);
        String routingName = routingNode.isDefined() ? routingNode.asString() : null;
        String address = DivertDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        String forwardingAddress = DivertDefinition.FORWARDING_ADDRESS.resolveModelAttribute(context, model).asString();
        boolean exclusive = DivertDefinition.EXCLUSIVE.resolveModelAttribute(context, model).asBoolean();
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filter = filterNode.isDefined() ? filterNode.asString() : null;
        DivertConfiguration config = new DivertConfiguration().setName(name).setRoutingName(routingName).setAddress(address).setForwardingAddress(forwardingAddress).setExclusive(exclusive).setFilterString(filter);
        ModelNode transformerClassName = CommonAttributes.TRANSFORMER_CLASS_NAME.resolveModelAttribute(context, model);
        if (transformerClassName.isDefined()) {
            config.setTransformerConfiguration(new TransformerConfiguration(transformerClassName.asString()));
        }
        return config;
    }

    static void createDivert(String name, DivertConfiguration divertConfiguration, ActiveMQServerControl serverControl) {
        try {
            String transformerClassName = divertConfiguration.getTransformerConfiguration() != null ? divertConfiguration.getTransformerConfiguration().getClassName() : null;
            serverControl.createDivert(name, divertConfiguration.getRoutingName(), divertConfiguration.getAddress(), divertConfiguration.getForwardingAddress(), divertConfiguration.isExclusive(), divertConfiguration.getFilterString(), transformerClassName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

