/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.shallow.ShallowResourceAdd;

public class DiscoveryGroupAdd
extends ShallowResourceAdd {
    public static final DiscoveryGroupAdd INSTANCE = new DiscoveryGroupAdd(false);
    public static final DiscoveryGroupAdd LEGACY_INSTANCE = new DiscoveryGroupAdd(true);
    private final boolean isLegacyCall;

    private DiscoveryGroupAdd(boolean isLegacyCall) {
        super(DiscoveryGroupDefinition.ATTRIBUTES);
        this.isLegacyCall = isLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (!this.isLegacyCall) {
            Object addHandler;
            ModelNode op = operation.clone();
            PathAddress target = context.getCurrentAddress().getParent();
            if (operation.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                target = target.append("jgroups-discovery-group", context.getCurrentAddressValue());
                addHandler = JGroupsDiscoveryGroupAdd.LEGACY_INSTANCE;
            } else if (operation.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
                target = target.append("socket-discovery-group", context.getCurrentAddressValue());
                addHandler = SocketDiscoveryGroupAdd.LEGACY_INSTANCE;
            } else {
                throw MessagingLogger.ROOT_LOGGER.socketBindingOrJGroupsClusterRequired();
            }
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)addHandler, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }
}

