/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeFactory;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeService;
import org.wildfly.security.credential.source.CredentialSource;

public class JMSBridgeAdd
extends AbstractAddStepHandler {
    public static final JMSBridgeAdd INSTANCE = new JMSBridgeAdd();

    private JMSBridgeAdd() {
        super(JMSBridgeDefinition.ATTRIBUTES);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get(JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE.getName()), (String)JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE.getName());
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get(JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE.getName()), (String)JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE.getName());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                String moduleName = JMSBridgeDefinition.MODULE.resolveModelAttribute(context, model).asStringOrNull();
                String bridgeName = context.getCurrentAddressValue();
                ServiceName bridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName);
                ServiceBuilder jmsBridgeServiceBuilder = context.getServiceTarget().addService(bridgeServiceName);
                jmsBridgeServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.transactions.global-default-local-provider", null));
                jmsBridgeServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
                Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)jmsBridgeServiceBuilder);
                if (JMSBridgeAdd.this.dependsOnLocalResources(context, model, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.SOURCE_DESTINATION);
                }
                if (JMSBridgeAdd.this.dependsOnLocalResources(context, model, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONTEXT)) {
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_CONNECTION_FACTORY);
                    JMSBridgeAdd.this.addDependencyForJNDIResource(jmsBridgeServiceBuilder, model, context, (AttributeDefinition)JMSBridgeDefinition.TARGET_DESTINATION);
                }
                jmsBridgeServiceBuilder.requires(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
                JMSBridgeService bridgeService = new JMSBridgeService(moduleName, bridgeName, JMSBridgeFactory.createJMSBridge(context, model), executorSupplier, JMSBridgeAdd.getCredentialStoreReference(JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE, context, model, jmsBridgeServiceBuilder, new String[0]), JMSBridgeAdd.getCredentialStoreReference(JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE, context, model, jmsBridgeServiceBuilder, new String[0]));
                jmsBridgeServiceBuilder.setInstance((Service)bridgeService);
                jmsBridgeServiceBuilder.install();
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    private boolean dependsOnLocalResources(OperationContext context, ModelNode model, AttributeDefinition attr) throws OperationFailedException {
        return JMSBridgeFactory.resolveContextProperties(attr, context, model).isEmpty();
    }

    private void addDependencyForJNDIResource(ServiceBuilder builder, ModelNode model, OperationContext context, AttributeDefinition attribute) throws OperationFailedException {
        String jndiName = attribute.resolveModelAttribute(context, model).asString();
        builder.requires(ContextNames.bindInfoFor((String)jndiName).getBinderServiceName());
    }

    private static ExceptionSupplier<CredentialSource, Exception> getCredentialStoreReference(ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, OperationContext context, ModelNode model, ServiceBuilder<?> serviceBuilder, String ... modelFilter) throws OperationFailedException {
        if (model.hasDefined(credentialReferenceAttributeDefinition.getName())) {
            ModelNode value;
            ModelNode filteredModelNode = model;
            if (modelFilter != null && modelFilter.length > 0) {
                for (String path : modelFilter) {
                    if (!filteredModelNode.get(path).isDefined()) break;
                    filteredModelNode = filteredModelNode.get(path);
                }
            }
            if ((value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, filteredModelNode)).isDefined()) {
                return CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)credentialReferenceAttributeDefinition, (ModelNode)filteredModelNode, serviceBuilder);
            }
        }
        return null;
    }
}

