/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.cdi;

import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.Unbound;
import org.jboss.weld.manager.api.WeldManager;

@ApplicationScoped
public class RequestContextCommandListener
implements CommandListener {
    private final WeldManager weldManager;
    private final RequestContext requestContext;
    private static final ThreadLocal<Boolean> isActivator = new ThreadLocal();

    @Inject
    public RequestContextCommandListener(@Unbound RequestContext requestContext, WeldManager weldManager) {
        this.requestContext = requestContext;
        this.weldManager = weldManager;
    }

    public void beforeExecution(FaultToleranceOperation operation) {
        if (operation.isAsync() && !this.weldManager.isContextActive(RequestScoped.class)) {
            this.requestContext.activate();
            isActivator.set(true);
        }
    }

    public void afterExecution(FaultToleranceOperation operation) {
        if (Boolean.TRUE.equals(isActivator.get())) {
            try {
                this.requestContext.invalidate();
                this.requestContext.deactivate();
            }
            finally {
                isActivator.remove();
            }
        }
    }
}

