/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.cdi;

import io.smallrye.faulttolerance.CommandListener;
import io.smallrye.faulttolerance.DefaultCommandListenersProvider;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.weld.inject.WeldInstance;

@Priority(value=1000)
@Alternative
@ApplicationScoped
public class WeldCommandListenersProvider
extends DefaultCommandListenersProvider {
    @Inject
    WeldInstance<CommandListener> listeners;

    public List<CommandListener> getCommandListeners() {
        if (this.listeners.isUnsatisfied()) {
            return null;
        }
        ArrayList<CommandListener> commandListeners = new ArrayList<CommandListener>();
        for (final WeldInstance.Handler handler : this.listeners.handlers()) {
            if (Dependent.class.equals((Object)handler.getBean().getScope())) {
                commandListeners.add(new CommandListener(){

                    public void beforeExecution(FaultToleranceOperation operation) {
                        ((CommandListener)handler.get()).beforeExecution(operation);
                    }

                    public void afterExecution(FaultToleranceOperation operation) {
                        ((CommandListener)handler.get()).afterExecution(operation);
                        handler.destroy();
                    }

                    public int getPriority() {
                        return ((CommandListener)handler.get()).getPriority();
                    }
                });
                continue;
            }
            commandListeners.add((CommandListener)handler.get());
        }
        Collections.sort(commandListeners);
        return commandListeners;
    }
}

