/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.undertow.server.HttpHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.microprofile.health.HealthHttpHandler;
import org.wildfly.extension.microprofile.health.HealthMonitor;
import org.wildfly.extension.microprofile.health.HealthMonitorService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

public class HealthHttpHandlerService
implements Service<HealthHttpHandler> {
    private final String path;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<HealthMonitor> healthMonitor = new InjectedValue();
    private HealthHttpHandler handler;
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"eclipse", "microprofile", "health", "http-handler"});

    static void install(OperationContext context, String serverName, String vhostName, String path) {
        HealthHttpHandlerService service = new HealthHttpHandlerService(path);
        context.getServiceTarget().addService(SERVICE_NAME, (Service)service).addDependency(UndertowService.virtualHostName((String)serverName, (String)vhostName), Host.class, service.host).addDependency(HealthMonitorService.SERVICE_NAME, HealthMonitor.class, service.healthMonitor).install();
    }

    public HealthHttpHandlerService(String path) {
        this.path = path;
    }

    public void start(StartContext context) throws StartException {
        this.handler = new HealthHttpHandler((HealthMonitor)this.healthMonitor.getValue());
        ((Host)this.host.getValue()).registerHandler(this.path, (HttpHandler)this.handler);
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).unregisterHandler("/health");
    }

    public HealthHttpHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this.handler;
    }
}

