/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.jboss.dmr.ModelNode;

public class WildFlyResponseFactory
implements HealthCheckResponseProvider {
    public HealthCheckResponseBuilder createResponseBuilder() {
        return new WildFlyResponseBuilder();
    }

    private static class WildFlyResponseBuilder
    extends HealthCheckResponseBuilder {
        private String name;
        private boolean state;
        private ModelNode data = new ModelNode();

        private WildFlyResponseBuilder() {
        }

        public HealthCheckResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HealthCheckResponseBuilder withData(String key, String value) {
            this.data.get(key).set(value);
            return this;
        }

        public HealthCheckResponseBuilder withData(String key, long value) {
            this.data.get(key).set(value);
            return this;
        }

        public HealthCheckResponseBuilder withData(String key, boolean value) {
            this.data.get(key).set(value);
            return this;
        }

        public HealthCheckResponseBuilder up() {
            return this.state(true);
        }

        public HealthCheckResponseBuilder down() {
            return this.state(false);
        }

        public HealthCheckResponseBuilder state(boolean up) {
            this.state = up;
            return this;
        }

        public HealthCheckResponse build() {
            return new WildFlyResponse(this.name, this.state, this.data);
        }

        private class WildFlyResponse
        extends HealthCheckResponse {
            private final String name;
            private final boolean up;
            private final Map<String, Object> data;

            public WildFlyResponse(String name, boolean up, ModelNode model) {
                this.name = name;
                this.up = up;
                this.data = this.setData(model);
            }

            private Map<String, Object> setData(ModelNode model) {
                if (!model.isDefined()) {
                    return null;
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (String key : model.keys()) {
                    Object value;
                    ModelNode modelValue = model.get(key);
                    switch (modelValue.getType()) {
                        case LONG: {
                            value = modelValue.asLong();
                            break;
                        }
                        case BOOLEAN: {
                            value = modelValue.asBoolean();
                            break;
                        }
                        default: {
                            value = modelValue.asString();
                        }
                    }
                    data.put(key, value);
                }
                return data;
            }

            public String getName() {
                return this.name;
            }

            public HealthCheckResponse.State getState() {
                return this.up ? HealthCheckResponse.State.UP : HealthCheckResponse.State.DOWN;
            }

            public Optional<Map<String, Object>> getData() {
                return Optional.ofNullable(this.data);
            }
        }
    }
}

