/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingContextFactory;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client.Version;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;

public final class WildFlyRootContext
implements Context {
    private static final NameParser NAME_PARSER;
    private final FastHashtable<String, Object> environment;
    private final ServiceLoader<NamingProviderFactory> namingProviderServiceLoader;
    private final ServiceLoader<NamingContextFactory> namingContextServiceLoader;

    public WildFlyRootContext(FastHashtable<String, Object> environment) {
        this(environment, WildFlyRootContext.secureGetContextClassLoader());
    }

    public WildFlyRootContext(FastHashtable<String, Object> environment, ClassLoader classLoader) {
        this.environment = environment;
        this.namingProviderServiceLoader = ServiceLoader.load(NamingProviderFactory.class, classLoader);
        this.namingContextServiceLoader = ServiceLoader.load(NamingContextFactory.class, classLoader);
    }

    private WildFlyRootContext(FastHashtable<String, Object> environment, ServiceLoader<NamingProviderFactory> namingProviderServiceLoader, ServiceLoader<NamingContextFactory> namingContextServiceLoader) {
        this.environment = environment;
        this.namingProviderServiceLoader = namingProviderServiceLoader;
        this.namingContextServiceLoader = namingContextServiceLoader;
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(WildFlyRootContext::getContextClassLoader) : WildFlyRootContext.getContextClassLoader();
        return contextClassLoader == null ? WildFlyRootContext.class.getClassLoader() : contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.lookup(this.getNameParser().parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderServiceLoader, this.namingContextServiceLoader);
        }
        return this.getProviderContext(reparsedName.getUrlScheme()).lookup(reparsedName.getName());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.bind(this.getNameParser().parse(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        this.getProviderContext(reparsedName.getUrlScheme()).bind(reparsedName.getName(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.rebind(this.getNameParser().parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        this.getProviderContext(reparsedName.getUrlScheme()).rebind(reparsedName.getName(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.unbind(this.getNameParser().parse(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        this.getProviderContext(reparsedName.getUrlScheme()).unbind(reparsedName.getName());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        this.rename(this.getNameParser().parse(oldName), this.getNameParser().parse(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Assert.checkNotNullParam((String)"oldName", (Object)oldName);
        Assert.checkNotNullParam((String)"newName", (Object)newName);
        ReparsedName oldReparsedName = this.reparse(oldName);
        ReparsedName newReparsedName = this.reparse(newName);
        this.getProviderContext(oldReparsedName.getUrlScheme()).rename(oldReparsedName.getName(), newReparsedName.getName());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.list(this.getNameParser().parse(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext(reparsedName.getUrlScheme()).list(reparsedName.getName()));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.listBindings(this.getNameParser().parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        return CloseableNamingEnumeration.fromEnumeration(this.getProviderContext(reparsedName.getUrlScheme()).listBindings(reparsedName.getName()));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        this.destroySubcontext(this.getNameParser().parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        this.getProviderContext(reparsedName.getUrlScheme()).destroySubcontext(reparsedName.getName());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.createSubcontext(this.getNameParser().parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        return this.getProviderContext(reparsedName.getUrlScheme()).createSubcontext(reparsedName.getName());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return this.lookupLink(this.getNameParser().parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        ReparsedName reparsedName = this.reparse(name);
        if (reparsedName.isEmpty()) {
            return new WildFlyRootContext((FastHashtable<String, Object>)this.environment.clone(), this.namingProviderServiceLoader, this.namingContextServiceLoader);
        }
        return this.getProviderContext(reparsedName.getUrlScheme()).lookupLink(reparsedName.getName());
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser();
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this.getNameParser();
    }

    private NameParser getNameParser() {
        return NAME_PARSER;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        return this.composeName(this.getNameParser().parse(name), this.getNameParser().parse(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return prefix.addAll(name);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public FastHashtable<String, Object> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    private Context getProviderContext(String nameScheme) throws NamingException {
        String providerScheme;
        URI providerUri;
        Object urlString = ((FastHashtable)this.getEnvironment()).get("java.naming.provider.url");
        try {
            providerUri = urlString == null ? null : new URI(urlString.toString());
        }
        catch (URISyntaxException e) {
            throw Messages.log.invalidProviderUri(e, urlString);
        }
        String string = providerScheme = providerUri == null ? null : providerUri.getScheme();
        if ((nameScheme == null || nameScheme.isEmpty()) && (providerScheme == null || providerScheme.isEmpty())) {
            return NamingUtils.emptyContext(this.getEnvironment());
        }
        ServiceLoader<NamingProviderFactory> providerLoader = this.namingProviderServiceLoader;
        ServiceLoader<NamingContextFactory> contextLoader = this.namingContextServiceLoader;
        ServiceLoader<NamingProviderFactory> serviceLoader = providerLoader;
        synchronized (serviceLoader) {
            Iterator<NamingProviderFactory> providerIterator = providerLoader.iterator();
            block9: while (true) {
                try {
                    while (providerIterator.hasNext()) {
                        NamingProviderFactory providerFactory = providerIterator.next();
                        if (!providerFactory.supportsUriScheme(providerScheme)) continue;
                        NamingProvider provider = providerFactory.createProvider(providerUri, (FastHashtable<String, Object>)this.getEnvironment());
                        Iterator<NamingContextFactory> contextIterator = contextLoader.iterator();
                        while (true) {
                            try {
                                NamingContextFactory contextFactory;
                                do {
                                    if (!contextIterator.hasNext()) continue block9;
                                } while (!(contextFactory = contextIterator.next()).supportsUriScheme(provider, nameScheme));
                                return contextFactory.createRootContext(provider, nameScheme, (FastHashtable<String, Object>)this.getEnvironment());
                            }
                            catch (ServiceConfigurationError error) {
                                Messages.log.serviceConfigFailed(error);
                                continue;
                            }
                            break;
                        }
                    }
                }
                catch (ServiceConfigurationError error) {
                    Messages.log.serviceConfigFailed(error);
                    continue;
                }
                break;
            }
            throw Messages.log.noProviderForUri(nameScheme);
        }
    }

    ReparsedName reparse(Name origName) throws InvalidNameException {
        String urlScheme;
        Name name = (Name)origName.clone();
        if (name.isEmpty()) {
            return new ReparsedName(null, name);
        }
        String first = name.get(0);
        int idx = first.indexOf(58);
        if (idx != -1) {
            urlScheme = first.substring(0, idx);
            String segment = first.substring(idx + 1);
            name.remove(0);
            if (segment.length() > 0 || origName.size() > 1 && origName.get(1).length() > 0) {
                name.add(0, segment);
            }
        } else {
            urlScheme = null;
        }
        return new ReparsedName(urlScheme, name);
    }

    static {
        Version.getVersion();
        NAME_PARSER = CompositeName::new;
    }

    class ReparsedName {
        final String urlScheme;
        final Name name;

        ReparsedName(String urlScheme, Name name) {
            this.urlScheme = urlScheme;
            this.name = name;
        }

        public String getUrlScheme() {
            return this.urlScheme;
        }

        public Name getName() {
            return this.name;
        }

        boolean isEmpty() {
            return this.urlScheme == null && this.name.isEmpty();
        }
    }
}

