/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.AbstractFederatingContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteClientTransport;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemoteContext
extends AbstractFederatingContext {
    private final RemoteNamingProvider provider;
    private final String scheme;

    RemoteContext(RemoteNamingProvider provider, String scheme, Hashtable<String, Object> env) throws CommunicationException {
        super(FastHashtable.of(env));
        this.provider = provider;
        this.scheme = scheme;
    }

    RemoteClientTransport getRemoteTransport(ConnectionPeerIdentity peerIdentity) throws NamingException {
        Endpoint endpoint = this.provider.getEndpoint();
        if (endpoint == null) {
            throw Messages.log.noRemotingEndpoint();
        }
        try {
            Connection connection = peerIdentity.getConnection();
            IoFuture future = RemoteClientTransport.SERVICE_HANDLE.getClientService(connection, OptionMap.EMPTY);
            try {
                return (RemoteClientTransport)future.getInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel();
                throw Messages.log.operationInterrupted();
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            throw Messages.log.connectFailed(e);
        }
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        return this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            return this.getRemoteTransport(peerIdentity).lookup(this, (Name)name_, peerIdentity, false);
        }, name, null);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        return this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            return this.getRemoteTransport(peerIdentity).lookup(this, (Name)name_, peerIdentity, true);
        }, name, null);
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        this.provider.performExceptionAction((name_, obj_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            this.getRemoteTransport(peerIdentity).bind((Name)name_, obj_, peerIdentity, false);
            return null;
        }, name, obj);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.provider.performExceptionAction((name_, obj_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            this.getRemoteTransport(peerIdentity).bind((Name)name_, obj_, peerIdentity, true);
            return null;
        }, name, obj);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            this.getRemoteTransport(peerIdentity).unbind((Name)name_, peerIdentity);
            return null;
        }, name, null);
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.provider.performExceptionAction((oldName_, newName_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            this.getRemoteTransport(peerIdentity).rename((Name)oldName_, (Name)newName_, peerIdentity);
            return null;
        }, oldName, newName);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        return (CloseableNamingEnumeration)this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            return this.getRemoteTransport(peerIdentity).list((Name)name_, peerIdentity);
        }, name, null);
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        return (CloseableNamingEnumeration)this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            return this.getRemoteTransport(peerIdentity).listBindings((Name)name_, this, peerIdentity);
        }, name, null);
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            this.getRemoteTransport(peerIdentity).destroySubcontext((Name)name_, peerIdentity);
            return null;
        }, name, null);
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        return (Context)this.provider.performExceptionAction((name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
            CompositeName compositeName = NamingUtils.toCompositeName(name_);
            this.getRemoteTransport(peerIdentity).createSubcontext(compositeName, peerIdentity);
            return new RelativeFederatingContext((FastHashtable<String, Object>)this.getEnvironment(), this, compositeName);
        }, name, null);
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }
}

