/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingLogger;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class BinderService
implements Service<ManagedReferenceFactory> {
    private final InjectedValue<ServiceBasedNamingStore> namingStoreValue = new InjectedValue();
    private final String name;
    private final InjectedValue<ManagedReferenceFactory> managedReferenceFactory = new InjectedValue();
    private final Object source;
    private final AtomicInteger refcnt = new AtomicInteger(0);
    private ServiceController<?> controller;
    private final ServiceName deploymentServiceName;

    public BinderService(String name, Object source, ServiceName deploymentServiceName) {
        this.name = name.startsWith("java:") ? name.substring(name.indexOf(47) + 1) : name;
        this.source = source;
        this.deploymentServiceName = deploymentServiceName;
    }

    public BinderService(String name, Object source) {
        this(name, source, null);
    }

    public BinderService(String name) {
        this(name, null, null);
    }

    public Object getSource() {
        return this.source;
    }

    public void acquire() {
        this.refcnt.incrementAndGet();
    }

    public void release() {
        if (this.refcnt.decrementAndGet() <= 0) {
            this.controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller;
        ServiceBasedNamingStore namingStore = (ServiceBasedNamingStore)this.namingStoreValue.getValue();
        this.controller = controller = context.getController();
        namingStore.add(controller.getName());
        NamingLogger.ROOT_LOGGER.tracef("Bound resource %s into naming store %s (service name %s)", this.name, namingStore, controller.getName());
        if (this.deploymentServiceName != null) {
            Set duBindingReferences = (Set)controller.getServiceContainer().getService(JndiNamingDependencyProcessor.serviceName(this.deploymentServiceName)).getValue();
            duBindingReferences.add(controller.getName());
        }
    }

    public synchronized void stop(StopContext context) {
        Set duBindingReferences;
        ServiceBasedNamingStore namingStore = (ServiceBasedNamingStore)this.namingStoreValue.getValue();
        namingStore.remove(context.getController().getName());
        if (this.deploymentServiceName != null && (duBindingReferences = (Set)this.controller.getServiceContainer().getService(JndiNamingDependencyProcessor.serviceName(this.deploymentServiceName)).getValue()) != null) {
            duBindingReferences.remove(this.controller.getName());
        }
    }

    public synchronized ManagedReferenceFactory getValue() throws IllegalStateException {
        return (ManagedReferenceFactory)this.managedReferenceFactory.getValue();
    }

    public Injector<ManagedReferenceFactory> getManagedObjectInjector() {
        return this.managedReferenceFactory;
    }

    public Injector<ServiceBasedNamingStore> getNamingStoreInjector() {
        return this.namingStoreValue;
    }

    public String toString() {
        return "BinderService[name=" + this.name + ",source=" + this.source + ",deployment=" + this.deploymentServiceName + "]";
    }
}

