/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.resolver.XBundleRevision;

public class DeferredPhaseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (brev == null || brev.isFragment()) {
            return;
        }
        ServiceName moduleService = ServiceModuleLoader.moduleServiceName((ModuleIdentifier)brev.getModuleIdentifier());
        phaseContext.addDeploymentDependency(moduleService, Attachments.MODULE);
        if (!brev.getBundle().isResolved()) {
            depUnit.putAttachment(Attachments.DEFERRED_ACTIVATION_COUNT, (Object)new AtomicInteger());
            DeploymentUtils.addDeferredModule((DeploymentUnit)depUnit);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

