/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.osgi.service.ModuleRegistrationTracker;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundleRevision;

class PersistentBundlesIntegration
extends BootstrapBundlesInstall<Void> {
    private final InitialDeploymentTracker deploymentTracker;

    PersistentBundlesIntegration(InitialDeploymentTracker deploymentTracker) {
        super(IntegrationServices.PERSISTENT_BUNDLES);
        this.deploymentTracker = deploymentTracker;
    }

    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(InitialDeploymentTracker.INITIAL_DEPLOYMENTS_COMPLETE);
        builder.addDependency(ModuleRegistrationTracker.MODULE_REGISTRATION_COMPLETE);
        builder.addDependency(IntegrationServices.BOOTSTRAP_BUNDLES_COMPLETE);
    }

    public void start(StartContext context) throws StartException {
        Set<Deployment> deployments = this.deploymentTracker.getDeployments();
        HashSet<XBundleRevision> installedRevisions = new HashSet<XBundleRevision>();
        for (Deployment dep : deployments) {
            XBundleRevision brev = (XBundleRevision)dep.getAttachment(IntegrationConstants.BUNDLE_REVISION_KEY);
            installedRevisions.add(brev);
        }
        this.installResolveService(context.getChildTarget(), installedRevisions);
    }
}

