/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.LayeredBundlePathFactory;
import org.jboss.as.osgi.service.ModuleIdentityRepository;
import org.jboss.as.osgi.service.RepositoryService;
import org.jboss.as.osgi.service.SystemPackagesIntegration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractBundleRevisionAdaptor;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.BootstrapBundlesResolve;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilder;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XRequirementBuilder;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

class BootstrapBundlesIntegration
extends BootstrapBundlesInstall<Void> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<StorageManager> injectedStorageManager = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XRepository> injectedRepository = new InjectedValue();
    private List<SubsystemState.OSGiCapability> modulecaps;
    private List<File> bundlesPath;

    BootstrapBundlesIntegration() {
        super(IntegrationServices.BOOTSTRAP_BUNDLES);
    }

    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(OSGiConstants.SUBSYSTEM_STATE_SERVICE_NAME, SubsystemState.class, this.injectedSubsystemState);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(RepositoryService.SERVICE_NAME, XRepository.class, this.injectedRepository);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.STORAGE_MANAGER_PLUGIN, StorageManager.class, this.injectedStorageManager);
    }

    public synchronized void start(StartContext context) throws StartException {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        this.bundlesPath = LayeredBundlePathFactory.resolveLayeredBundlePath(serverEnvironment);
        this.modulecaps = new ArrayList<SubsystemState.OSGiCapability>();
        ArrayList<SubsystemState.OSGiCapability> configcaps = new ArrayList<SubsystemState.OSGiCapability>();
        for (String capspec : SystemPackagesIntegration.DEFAULT_CAPABILITIES) {
            configcaps.add(new SubsystemState.OSGiCapability(capspec, null));
        }
        configcaps.addAll(((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities());
        Iterator iterator = configcaps.iterator();
        while (iterator.hasNext()) {
            SubsystemState.OSGiCapability configcap = (SubsystemState.OSGiCapability)iterator.next();
            String identifier = configcap.getIdentifier();
            if (!this.isValidModuleIdentifier(identifier)) continue;
            try {
                Module module = this.installInitialModuleCapability(configcap);
                if (module == null) continue;
                this.modulecaps.add(configcap);
                iterator.remove();
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapability(ex, identifier);
            }
        }
        for (SubsystemState.OSGiCapability configcap : configcaps) {
            String identifier = configcap.getIdentifier();
            try {
                Deployment dep = this.getInitialBundleDeployment(configcap);
                deployments.add(dep);
            }
            catch (Exception ex) {
                throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapability(ex, identifier);
            }
        }
        this.installBootstrapBundles(context.getChildTarget(), deployments);
    }

    protected ServiceController<Void> installResolveService(ServiceTarget serviceTarget, Set<XBundleRevision> installedRevisions) {
        return new BootstrapResolveIntegration(this.getServiceName().getParent(), installedRevisions).install(serviceTarget, this.getServiceListener());
    }

    private Module installInitialModuleCapability(SubsystemState.OSGiCapability configcap) throws Exception {
        XBundleRevision brev;
        Module module;
        String identifier = configcap.getIdentifier();
        ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
        File bundleFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesPath, moduleId);
        if (bundleFile != null) {
            return null;
        }
        OSGiLogger.LOGGER.tracef("Installing initial module capability: %s", identifier);
        try {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            module = moduleLoader.loadModule(moduleId);
        }
        catch (ModuleLoadException ex) {
            throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(ex, identifier);
        }
        OSGiMetaData metadata = this.getModuleMetadata(module);
        final BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

            public XBundleRevision createResource() {
                return new AbstractBundleRevisionAdaptor(syscontext, module);
            }
        };
        XBundleRevisionBuilder builder = XBundleRevisionBuilderFactory.create((XBundleRevisionBuilderFactory)factory);
        if (metadata != null) {
            builder.loadFrom(metadata);
            brev = (XBundleRevision)builder.getResource();
            brev.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, (Object)metadata);
        } else {
            builder.loadFrom(module);
            brev = (XBundleRevision)builder.getResource();
        }
        ((XEnvironment)this.injectedEnvironment.getValue()).installResources(new XResource[]{brev});
        Integer startlevel = configcap.getStartLevel();
        if (startlevel != null && startlevel > 0) {
            XBundle bundle2 = brev.getBundle();
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle2.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(startlevel.intValue());
        }
        return module;
    }

    private Deployment getInitialBundleDeployment(SubsystemState.OSGiCapability configcap) throws Exception {
        String identifier = configcap.getIdentifier();
        Integer level = configcap.getStartLevel();
        Deployment deployment = null;
        if (this.isValidModuleIdentifier(identifier)) {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
            File bundleFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesPath, moduleId);
            if (bundleFile != null) {
                OSGiLogger.LOGGER.tracef("Installing initial bundle capability: %s", identifier);
                URL bundleURL = bundleFile.toURI().toURL();
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        } else if (this.isValidMavenIdentifier(identifier)) {
            OSGiLogger.LOGGER.tracef("Installing initial maven capability: %s", identifier);
            XRepository repository = (XRepository)this.injectedRepository.getValue();
            MavenCoordinates mavenId = MavenCoordinates.parse((String)identifier);
            XRequirement req = XRequirementBuilder.create((MavenCoordinates)mavenId).getRequirement();
            Collection caps = repository.findProviders((Requirement)req);
            if (!caps.isEmpty()) {
                XResource resource = (XResource)((Capability)caps.iterator().next()).getResource();
                XCapability ccap = (XCapability)resource.getCapabilities("osgi.content").get(0);
                URL bundleURL = new URL((String)ccap.getAttribute("url"));
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        }
        if (deployment == null) {
            throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(null, identifier);
        }
        return deployment;
    }

    private boolean isValidModuleIdentifier(String identifier) {
        try {
            ModuleIdentifier.fromString((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidMavenIdentifier(String identifier) {
        try {
            MavenCoordinates.parse((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Deployment getDeploymentFromURL(URL bundleURL, String location, Integer level) throws Exception {
        int startlevel;
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.toVirtualFile((URL)bundleURL), (String)location);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        int n = startlevel = level != null ? level : 0;
        if (startlevel > 0) {
            dep.setStartLevel(Integer.valueOf(level));
            dep.setAutoStart(true);
        }
        StorageManager storageManager = (StorageManager)this.injectedStorageManager.getValue();
        Long bundleId = ((XEnvironment)this.injectedEnvironment.getValue()).nextResourceIdentifier(null, dep.getSymbolicName());
        StorageState storageState = storageManager.createStorageState(bundleId.longValue(), location, Integer.valueOf(startlevel), null);
        dep.putAttachment(IntegrationConstants.STORAGE_STATE_KEY, (Object)storageState);
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws Exception {
        Manifest manifest = null;
        ModuleIdentifier identifier = module.getIdentifier();
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        Iterator itres = moduleClassLoader.iterateResources("/META-INF", false);
        while (itres.hasNext()) {
            Resource res = (Resource)itres.next();
            if (!res.getName().equals("META-INF/MANIFEST.MF")) continue;
            if (manifest != null) {
                OSGiLogger.LOGGER.debugf("Cannot process multiple manifest entries for: %s", identifier);
                manifest = null;
                break;
            }
            try (InputStream input = res.openStream();){
                manifest = new Manifest(input);
            }
        }
        if (OSGiManifestBuilder.isValidBundleManifest(manifest)) {
            return OSGiMetaDataBuilder.load(manifest);
        }
        FileSystem fileSystem = FileSystems.getDefault();
        File homeDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getHomeDir();
        Path modulesPath = fileSystem.getPath(homeDir.getAbsolutePath(), "modules", "system", "layers", "base");
        String identifierPath = identifier.getName().replace('.', File.separatorChar) + File.separator + identifier.getSlot();
        File entryFile = fileSystem.getPath(modulesPath.toString(), identifierPath, "jbosgi-xservice.properties").toFile();
        if (entryFile.exists()) {
            try (FileInputStream input = new FileInputStream(entryFile);){
                Properties props = new Properties();
                props.load(input);
                OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((Properties)props);
                return oSGiMetaData;
            }
        }
        return null;
    }

    class BootstrapActivateIntegration
    extends BootstrapBundlesActivate<Void> {
        BootstrapActivateIntegration(ServiceName baseName, Set<XBundle> resolvedBundles) {
            super(baseName, resolvedBundles);
        }

        public void start(StartContext context) throws StartException {
            BundleManager bundleManager = (BundleManager)BootstrapBundlesIntegration.this.injectedBundleManager.getValue();
            for (SubsystemState.OSGiCapability modcap : BootstrapBundlesIntegration.this.modulecaps) {
                if (modcap.getStartLevel() == null) continue;
                String identifier = modcap.getIdentifier();
                XBundle bundle2 = bundleManager.getBundleByLocation(identifier);
                try {
                    bundle2.start(2);
                }
                catch (BundleException ex) {
                    OSGiLogger.LOGGER.errorCannotStartBundle(ex, (Bundle)bundle2);
                }
            }
            super.start(context);
        }
    }

    class BootstrapResolveIntegration
    extends BootstrapBundlesResolve<Void> {
        BootstrapResolveIntegration(ServiceName baseName, Set<XBundleRevision> installedRevisions) {
            super(baseName, installedRevisions);
        }

        protected ServiceController<Void> installActivateService(ServiceTarget serviceTarget, Set<XBundle> resolvedBundles) {
            return new BootstrapActivateIntegration(this.getServiceName().getParent(), resolvedBundles).install(serviceTarget, this.getServiceListener());
        }
    }
}

