/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.service.LayeredBundlePathFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public final class ModuleIdentityRepository
extends AbstractRepository {
    private final File modulesDir;
    private final List<File> bundlesPath;

    public ModuleIdentityRepository(ServerEnvironment serverEnvironment) {
        File bundlesDir = serverEnvironment.getBundlesDir();
        if (!bundlesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(bundlesDir);
        }
        this.modulesDir = new File(bundlesDir.getParent() + File.separator + "modules");
        if (!this.modulesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(this.modulesDir);
        }
        this.bundlesPath = LayeredBundlePathFactory.resolveLayeredBundlePath(serverEnvironment);
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<XCapability> result = new ArrayList<XCapability>();
        if ("module.identity".equals(namespace)) {
            String moduleId = (String)req.getAttributes().get("module.identity");
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString((String)moduleId);
            try {
                File contentFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesPath, moduleIdentifier);
                if (contentFile == null) {
                    contentFile = ModuleIdentityRepository.getRepositoryEntryFromModuleLoader(moduleIdentifier);
                }
                if (contentFile == null) {
                    contentFile = ModuleIdentityRepository.getRepositoryEntry(this.modulesDir, moduleIdentifier);
                }
                if (contentFile != null) {
                    URL contentURL = contentFile.toURI().toURL();
                    XResourceBuilder builder = URLResourceBuilderFactory.create((URL)contentURL, null);
                    XCapability cap = builder.addCapability("module.identity", moduleId);
                    builder.getResource();
                    result.add(cap);
                }
            }
            catch (RepositoryResolutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RepositoryResolutionException((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static File getRepositoryEntry(List<File> bundlesPath, ModuleIdentifier identifier) throws IOException {
        String identifierPath = ModuleIdentityRepository.getModuleIdAsPath(identifier);
        for (File bundlesDir : bundlesPath) {
            File contentFile = ModuleIdentityRepository.getRepositoryEntry(bundlesDir, identifierPath);
            if (contentFile == null) continue;
            return contentFile;
        }
        return null;
    }

    private static File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = ModuleIdentityRepository.getModuleIdAsPath(identifier);
        return ModuleIdentityRepository.getRepositoryEntry(rootDir, identifierPath);
    }

    private static File getRepositoryEntry(File rootDir, String identifierPath) throws IOException {
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            OSGiLogger.LOGGER.tracef("Cannot obtain directory: %s", entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            OSGiLogger.LOGGER.tracef("Cannot find jar in: %s", entryDir);
            return null;
        }
        if (files.length > 1) {
            OSGiLogger.LOGGER.tracef("Multiple jars in: %s", entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            OSGiLogger.LOGGER.tracef("File does not exist: %s", entryFile);
            return null;
        }
        return entryFile;
    }

    private static File getRepositoryEntryFromModuleLoader(ModuleIdentifier moduleIdentifier) {
        String identifierPath = ModuleIdentityRepository.getModuleIdAsPath(moduleIdentifier);
        try {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            Module module = moduleLoader.loadModule(moduleIdentifier);
            Enumeration manifestURLs = module.getClassLoader().getResources("META-INF");
            while (manifestURLs.hasMoreElements()) {
                URL manifestURL = (URL)manifestURLs.nextElement();
                String manifestString = manifestURL.toExternalForm();
                int idx = manifestString.indexOf(identifierPath);
                if (idx <= -1) continue;
                String parent = manifestString.substring(0, idx);
                if (parent.startsWith("jar:")) {
                    parent = parent.substring(4);
                }
                try {
                    File file = new File(new URI(parent));
                    return ModuleIdentityRepository.getRepositoryEntry(file, moduleIdentifier);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        catch (ModuleLoadException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getModuleIdAsPath(ModuleIdentifier moduleIdentifier) {
        return moduleIdentifier.getName().replace('.', '/') + "/" + moduleIdentifier.getSlot();
    }
}

