/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.RepositoryService;
import org.jboss.as.server.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.provision.AbstractResourceProvisioner;
import org.jboss.osgi.provision.ProvisionException;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.osgi.service.repository.RepositoryContent;

public final class ResourceProvisionerService
extends AbstractService<XResourceProvisioner> {
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<XPersistentRepository> injectedRepository = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private ModelControllerClient modelControllerClient;
    private XResourceProvisioner provisioner;

    public static ServiceController<?> addService(ServiceTarget target) {
        ResourceProvisionerService service = new ResourceProvisionerService();
        ServiceBuilder builder = target.addService(OSGiConstants.PROVISIONER_SERVICE_NAME, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedController);
        builder.addDependency(RepositoryService.SERVICE_NAME, XPersistentRepository.class, service.injectedRepository);
        builder.addDependency(OSGiConstants.ABSTRACT_RESOLVER_SERVICE_NAME, XResolver.class, service.injectedResolver);
        return builder.install();
    }

    private ResourceProvisionerService() {
    }

    public void start(StartContext startContext) throws StartException {
        ModelController modelController = (ModelController)this.injectedController.getValue();
        this.modelControllerClient = modelController.createClient((Executor)Executors.newCachedThreadPool());
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        XPersistentRepository repository = (XPersistentRepository)this.injectedRepository.getValue();
        final ServerDeploymentHelper serverDeployer = new ServerDeploymentHelper(this.modelControllerClient);
        this.provisioner = new AbstractResourceProvisioner(resolver, repository, "osgi.bundle"){

            public <T> List<T> installResources(List<XResource> resources, Class<T> type) throws ProvisionException {
                ArrayList<String> result = new ArrayList<String>();
                for (XResource res : resources) {
                    String name = res.getIdentityCapability().getName();
                    InputStream input = ((RepositoryContent)res).getContent();
                    try {
                        String runtimeName = serverDeployer.deploy(name, input);
                        result.add(runtimeName);
                    }
                    catch (ServerDeploymentHelper.ServerDeploymentException ex) {
                        throw new ProvisionException((Throwable)ex);
                    }
                }
                return Collections.unmodifiableList(result);
            }
        };
    }

    public synchronized void stop(StopContext context) {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized XResourceProvisioner getValue() throws IllegalStateException {
        return this.provisioner;
    }
}

