/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.web.WebExtension;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class WebContextLifecycleInterceptor
extends AbstractLifecycleInterceptor
implements Service<LifecycleInterceptor> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "osgi", "web"}).append(new String[]{WebContextLifecycleInterceptor.class.getSimpleName()});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private ServiceRegistration<LifecycleInterceptor> registration;

    WebContextLifecycleInterceptor() {
    }

    static ServiceController<LifecycleInterceptor> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        WebContextLifecycleInterceptor service = new WebContextLifecycleInterceptor();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        builder.addListener((ServiceListener)verificationHandler);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    public void start(StartContext context) throws StartException {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = syscontext.registerService(LifecycleInterceptor.class, (Object)this, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public void invoke(int state, InvocationContext context) {
        XBundle bundle = (XBundle)context.getBundle();
        XBundleRevision brev = bundle.getBundleRevision();
        ContextActivator activator = (ContextActivator)brev.getAttachment(WebExtension.CONTEXT_ACTIVATOR_KEY);
        if (activator != null) {
            switch (state) {
                case 32: {
                    try {
                        if (!activator.start(30L, TimeUnit.SECONDS)) {
                            throw new LifecycleInterceptorException(OSGiMessages.MESSAGES.startContextFailed());
                        }
                        this.injectBundleContext(activator.getServletContext(), bundle.getBundleContext());
                        break;
                    }
                    catch (TimeoutException ex) {
                        throw new LifecycleInterceptorException(ex.getMessage(), (Throwable)ex);
                    }
                }
                case 4: {
                    this.uninjectBundleContext(activator.getServletContext());
                    activator.stop(30L, TimeUnit.SECONDS);
                }
            }
        }
    }

    private void injectBundleContext(ServletContext webContext, BundleContext bundleContext) {
        OSGiLogger.LOGGER.debugf("Injecting bundle context %s into %s", (Object)bundleContext, (Object)webContext);
        webContext.setAttribute("osgi-bundlecontext", (Object)bundleContext);
        this.registerServletContextService(webContext, bundleContext);
    }

    private void uninjectBundleContext(ServletContext webContext) {
        if (webContext != null) {
            OSGiLogger.LOGGER.debugf("Uninjecting bundle context from %s", (Object)webContext);
            webContext.removeAttribute("osgi-bundlecontext");
        }
    }

    private void registerServletContextService(ServletContext servletContext, BundleContext bundleContext) {
        Object contextPath;
        Bundle bundle = bundleContext.getBundle();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.web.symbolicname", bundle.getSymbolicName());
        Dictionary headers = bundle.getHeaders();
        Object version = headers.get("Bundle-Version");
        if (version instanceof String) {
            ((Dictionary)props).put("osgi.web.version", (String)version);
        }
        if ((contextPath = headers.get("Web-ContextPath")) instanceof String) {
            ((Dictionary)props).put("osgi.web.contextpath", (String)contextPath);
        }
        bundleContext.registerService(ServletContext.class.getName(), (Object)servletContext, props);
    }

    public LifecycleInterceptor getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

