/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.IOException;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationModificationImpl;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledIdentityImpl;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.LayerInfo;
import org.jboss.as.patching.installation.MutableTargetImpl;
import org.jboss.as.patching.installation.PatchableTarget;

public class InstallationManagerImpl
extends InstallationManager {
    private volatile InstalledIdentity installedIdentity;
    private final AtomicBoolean writable = new AtomicBoolean(true);
    private final InstalledImage installedImage;
    private static final AtomicBoolean restartRequired = new AtomicBoolean(false);

    public InstallationManagerImpl(InstalledIdentity installedIdentity) {
        this.installedIdentity = installedIdentity;
        this.installedImage = installedIdentity.getInstalledImage();
    }

    @Override
    public Identity getIdentity() {
        return this.installedIdentity.getIdentity();
    }

    @Override
    public List<String> getLayerNames() {
        return this.installedIdentity.getLayerNames();
    }

    @Override
    public Layer getLayer(String layerName) {
        return this.installedIdentity.getLayer(layerName);
    }

    @Override
    public List<Layer> getLayers() {
        return this.installedIdentity.getLayers();
    }

    @Override
    public Collection<String> getAddOnNames() {
        return this.installedIdentity.getAddOnNames();
    }

    @Override
    public AddOn getAddOn(String addOnName) {
        return this.installedIdentity.getAddOn(addOnName);
    }

    @Override
    public Collection<AddOn> getAddOns() {
        return this.installedIdentity.getAddOns();
    }

    @Override
    public InstalledImage getInstalledImage() {
        return this.installedImage;
    }

    @Override
    public InstallationManager.InstallationModification modifyInstallation(final InstallationManager.ModificationCompletionCallback callback) {
        if (!this.writable.compareAndSet(true, false)) {
            throw new ConcurrentModificationException();
        }
        try {
            final InstalledIdentity installedIdentity = this.installedIdentity;
            final Identity identity = installedIdentity.getIdentity();
            PatchableTarget.TargetInfo identityInfo = identity.loadTargetInfo();
            InstallationModificationImpl.InstallationState state = InstallationManagerImpl.load(installedIdentity);
            return new InstallationModificationImpl(identityInfo, identity.getName(), identity.getVersion(), state){

                @Override
                public InstalledIdentity getUnmodifiedInstallationState() {
                    return installedIdentity;
                }

                @Override
                public void complete() {
                    try {
                        InstallationManagerImpl.this.installedIdentity = InstallationManagerImpl.this.updateState(identity.getName(), this, this.internalComplete());
                        InstallationManagerImpl.this.writable.set(true);
                    }
                    catch (Exception e) {
                        this.cancel();
                        throw new RuntimeException(e);
                    }
                    if (callback != null) {
                        callback.completed();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    try {
                        if (callback != null) {
                            callback.canceled();
                        }
                    }
                    finally {
                        InstallationManagerImpl.this.writable.set(true);
                    }
                }
            };
        }
        catch (Exception e) {
            this.writable.set(true);
            throw new RuntimeException(e);
        }
    }

    protected static InstallationModificationImpl.InstallationState load(InstalledIdentity installedIdentity) throws IOException {
        InstallationModificationImpl.InstallationState state = new InstallationModificationImpl.InstallationState();
        for (Layer layer : installedIdentity.getLayers()) {
            state.putLayer(layer);
        }
        for (AddOn addOn : installedIdentity.getAddOns()) {
            state.putAddOn(addOn);
        }
        return state;
    }

    protected InstalledIdentity updateState(final String name, final InstallationModificationImpl modification, InstallationModificationImpl.InstallationState state) {
        MutableTargetImpl target;
        final PatchableTarget.TargetInfo identityInfo = modification.getModifiedState();
        Identity identity = new Identity(){

            @Override
            public String getVersion() {
                return modification.getVersion();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public PatchableTarget.TargetInfo loadTargetInfo() throws IOException {
                return identityInfo;
            }

            @Override
            public DirectoryStructure getDirectoryStructure() {
                return modification.getDirectoryStructure();
            }
        };
        InstalledIdentityImpl installedIdentity = new InstalledIdentityImpl(identity, this.installedImage);
        for (Map.Entry<String, MutableTargetImpl> entry : state.getLayers().entrySet()) {
            String layerName = entry.getKey();
            target = entry.getValue();
            installedIdentity.putLayer(layerName, new LayerInfo(layerName, target.getModifiedState(), target.getDirectoryStructure()));
        }
        for (Map.Entry<String, MutableTargetImpl> entry : state.getAddOns().entrySet()) {
            String addOnName = entry.getKey();
            target = entry.getValue();
            installedIdentity.putAddOn(addOnName, new LayerInfo(addOnName, target.getModifiedState(), target.getDirectoryStructure()));
        }
        return installedIdentity;
    }

    @Override
    public boolean requiresRestart() {
        return restartRequired.get();
    }

    @Override
    public boolean restartRequired() {
        return restartRequired.compareAndSet(false, true);
    }

    @Override
    public void clearRestartRequired() {
        restartRequired.set(false);
    }
}

