/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.runner.PatchingTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class FileRemoveTask
implements PatchingTask {
    private final MiscContentItem item;
    private final File target;
    private final File backup;
    private final PatchingTaskDescription description;
    private final List<ContentModification> rollback = new ArrayList<ContentModification>();

    FileRemoveTask(PatchingTaskDescription description, File target, File backup) {
        this.target = target;
        this.backup = backup;
        this.description = description;
        this.item = description.getContentItem(MiscContentItem.class);
    }

    @Override
    public ContentItem getContentItem() {
        return this.item;
    }

    @Override
    public boolean prepare(PatchingTaskContext context) throws IOException {
        this.backup(this.target, this.backup, Arrays.asList(this.item.getPath()), this.rollback, context);
        byte[] expected = this.description.getModification().getTargetHash();
        byte[] actual = HashUtils.hashFile(this.target);
        return Arrays.equals(expected, actual);
    }

    @Override
    public void execute(PatchingTaskContext context) throws IOException {
        boolean ok = IoUtils.recursiveDelete(this.target);
        for (ContentModification mod : this.rollback) {
            context.recordChange(null, mod);
        }
        if (!ok) {
            throw PatchMessages.MESSAGES.failedToDelete(this.target.getAbsolutePath());
        }
    }

    void backup(File root, File backupLocation, List<String> path, List<ContentModification> rollback, PatchingTaskContext context) throws IOException {
        if (root.exists()) {
            if (root.isDirectory()) {
                File[] files = root.listFiles();
                String rootName = root.getName();
                if (files == null || files.length == 0) {
                    rollback.add(FileRemoveTask.createRollbackItem(rootName, path, IoUtils.NO_CONTENT, true));
                } else {
                    ArrayList<String> newPath = new ArrayList<String>(path);
                    newPath.add(rootName);
                    for (File file : files) {
                        String name = file.getName();
                        File newBackupLocation = new File(backupLocation, name);
                        this.backup(file, newBackupLocation, newPath, rollback, context);
                    }
                }
            } else {
                byte[] hash = IoUtils.copy(root, backupLocation);
                rollback.add(FileRemoveTask.createRollbackItem(root.getName(), path, hash, false));
            }
        }
    }

    static ContentModification createRollbackItem(String name, List<String> path, byte[] backupHash, boolean directory) {
        MiscContentItem backupItem = new MiscContentItem(name, path, backupHash, directory);
        return new ContentModification(backupItem, IoUtils.NO_CONTENT, ModificationType.ADD);
    }
}

