package org.jboss.as.pojo.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import org.jboss.as.server.deployment.DeploymentUnit;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-03T23:24:31-0500")
public class PojoLogger_$logger extends DelegatingBasicLogger implements PojoLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PojoLogger_$logger.class.getName();
    public PojoLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void oldNamespace(final Object namespace) {
        super.log.logf(FQCN, INFO, null, oldNamespace$str(), namespace);
    }
    private static final String oldNamespace = "WFLYPOJO0001: Found legacy bean/pojo namespace: %s - might be missing some xml features (potential exceptions).";
    protected String oldNamespace$str() {
        return oldNamespace;
    }
    @Override
    public final void ignoreUninstallError(final Object joinpoint, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, ignoreUninstallError$str(), joinpoint);
    }
    private static final String ignoreUninstallError = "WFLYPOJO0002: Ignoring uninstall action on target: %s";
    protected String ignoreUninstallError$str() {
        return ignoreUninstallError;
    }
    @Override
    public final void invokingCallback(final Object callback, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, invokingCallback$str(), callback);
    }
    private static final String invokingCallback = "WFLYPOJO0003: Error invoking callback: %s";
    protected String invokingCallback$str() {
        return invokingCallback;
    }
    @Override
    public final void errorAtIncallback(final Object callback, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, errorAtIncallback$str(), callback);
    }
    private static final String errorAtIncallback = "WFLYPOJO0004: Error invoking incallback: %s";
    protected String errorAtIncallback$str() {
        return errorAtIncallback;
    }
    @Override
    public final void errorAtUncallback(final Object callback, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, errorAtUncallback$str(), callback);
    }
    private static final String errorAtUncallback = "WFLYPOJO0005: Error invoking uncallback: %s";
    protected String errorAtUncallback$str() {
        return errorAtUncallback;
    }
    private static final String noModuleFound = "WFLYPOJO0006: Failed to get module attachment for %s";
    protected String noModuleFound$str() {
        return noModuleFound;
    }
    @Override
    public final DeploymentUnitProcessingException noModuleFound(final DeploymentUnit unit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noModuleFound$str(), unit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingReflectionIndex = "WFLYPOJO0007: Missing deployment reflection index for %s";
    protected String missingReflectionIndex$str() {
        return missingReflectionIndex;
    }
    @Override
    public final DeploymentUnitProcessingException missingReflectionIndex(final DeploymentUnit unit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), missingReflectionIndex$str(), unit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParse = "WFLYPOJO0008: Failed to parse POJO xml [ %s ]";
    protected String failedToParse$str() {
        return failedToParse;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParse(final VirtualFile file) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParse$str(), file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiate = "WFLYPOJO0009: Cannot instantiate new instance.";
    protected String cannotInstantiate$str() {
        return cannotInstantiate;
    }
    @Override
    public final IllegalArgumentException cannotInstantiate(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiate$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateCollection = "WFLYPOJO0010: Cannot instantiate new collection instance.";
    protected String cannotInstantiateCollection$str() {
        return cannotInstantiateCollection;
    }
    @Override
    public final IllegalArgumentException cannotInstantiateCollection(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiateCollection$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateMap = "WFLYPOJO0011: Cannot instantiate new map instance.";
    protected String cannotInstantiateMap$str() {
        return cannotInstantiateMap;
    }
    @Override
    public final IllegalArgumentException cannotInstantiateMap(final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInstantiateMap$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooDynamicFromFactory = "WFLYPOJO0012: Too dynamic to determine injected type from factory!";
    protected String tooDynamicFromFactory$str() {
        return tooDynamicFromFactory;
    }
    @Override
    public final IllegalArgumentException tooDynamicFromFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tooDynamicFromFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooDynamicFromDependency = "WFLYPOJO0013: Too dynamic to determine injected type from dependency!";
    protected String tooDynamicFromDependency$str() {
        return tooDynamicFromDependency;
    }
    @Override
    public final IllegalArgumentException tooDynamicFromDependency() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), tooDynamicFromDependency$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notValueConfig = "WFLYPOJO0014: Previous node is not a value config: %s";
    protected String notValueConfig$str() {
        return notValueConfig;
    }
    @Override
    public final IllegalArgumentException notValueConfig(final ConfigVisitorNode previous) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notValueConfig$str(), previous));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullFactoryMethod = "WFLYPOJO0015: Null factory method!";
    protected String nullFactoryMethod$str() {
        return nullFactoryMethod;
    }
    @Override
    public final IllegalArgumentException nullFactoryMethod() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullFactoryMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullBeanInfo = "WFLYPOJO0016: Null bean info!";
    protected String nullBeanInfo$str() {
        return nullBeanInfo;
    }
    @Override
    public final IllegalArgumentException nullBeanInfo() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullBeanInfo$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMatchSize = "WFLYPOJO0017: Invalid number of type instances match: %s, type: %s";
    protected String invalidMatchSize$str() {
        return invalidMatchSize;
    }
    @Override
    public final IllegalArgumentException invalidMatchSize(final Set set, final Class type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMatchSize$str(), set, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDetermineInjectedType = "WFLYPOJO0018: Cannot determine injected type: %s, try setting class attribute (if available).";
    protected String cannotDetermineInjectedType$str() {
        return cannotDetermineInjectedType;
    }
    @Override
    public final IllegalArgumentException cannotDetermineInjectedType(final String info) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotDetermineInjectedType$str(), info));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullOrEmptyAlias = "WFLYPOJO0019: Null or empty alias.";
    protected String nullOrEmptyAlias$str() {
        return nullOrEmptyAlias;
    }
    @Override
    public final IllegalArgumentException nullOrEmptyAlias() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullOrEmptyAlias$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullOrEmptyDependency = "WFLYPOJO0020: Null or empty dependency.";
    protected String nullOrEmptyDependency$str() {
        return nullOrEmptyDependency;
    }
    @Override
    public final IllegalArgumentException nullOrEmptyDependency() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullOrEmptyDependency$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingValue = "WFLYPOJO0021: Missing value";
    protected String missingValue$str() {
        return missingValue;
    }
    @Override
    public final String missingValue() {
        return String.format(getLoggingLocale(), missingValue$str());
    }
    private static final String nullValue = "WFLYPOJO0022: Null value";
    protected String nullValue$str() {
        return nullValue;
    }
    @Override
    public final IllegalArgumentException nullValue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullValue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullName = "WFLYPOJO0023: Null name";
    protected String nullName$str() {
        return nullName;
    }
    @Override
    public final IllegalArgumentException nullName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullMethodName = "WFLYPOJO0024: Null method name!";
    protected String nullMethodName$str() {
        return nullMethodName;
    }
    @Override
    public final IllegalArgumentException nullMethodName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullMethodName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownType = "WFLYPOJO0025: Unknown type: %s";
    protected String unknownType$str() {
        return unknownType;
    }
    @Override
    public final IllegalArgumentException unknownType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalParameterLength = "WFLYPOJO0026: Illegal parameter length: %s";
    protected String illegalParameterLength$str() {
        return illegalParameterLength;
    }
    @Override
    public final IllegalArgumentException illegalParameterLength(final Object info) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalParameterLength$str(), info));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingFactoryMethod = "WFLYPOJO0027: Missing factory method in ctor configuration: %s";
    protected String missingFactoryMethod$str() {
        return missingFactoryMethod;
    }
    @Override
    public final StartException missingFactoryMethod(final BeanMetaDataConfig beanConfig) {
        final StartException result = new StartException(String.format(getLoggingLocale(), missingFactoryMethod$str(), beanConfig));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBeanInfo = "WFLYPOJO0028: Missing bean info, set bean's class attribute: %s";
    protected String missingBeanInfo$str() {
        return missingBeanInfo;
    }
    @Override
    public final String missingBeanInfo(final BeanMetaDataConfig beanConfig) {
        return String.format(getLoggingLocale(), missingBeanInfo$str(), beanConfig);
    }
    private static final String wrongTypeSize = "WFLYPOJO0029: Wrong types size, doesn't match parameters!";
    protected String wrongTypeSize$str() {
        return wrongTypeSize;
    }
    @Override
    public final IllegalArgumentException wrongTypeSize() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongTypeSize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullClassInfo = "WFLYPOJO0030: Null ClassInfo!";
    protected String nullClassInfo$str() {
        return nullClassInfo;
    }
    @Override
    public final IllegalArgumentException nullClassInfo() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullClassInfo$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ctorNotFound = "WFLYPOJO0031: No such constructor: %s for class %s.";
    protected String ctorNotFound$str() {
        return ctorNotFound;
    }
    @Override
    public final IllegalArgumentException ctorNotFound(final Object args, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ctorNotFound$str(), args, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String methodNotFound = "WFLYPOJO0032: Method not found %s%s for class %s.";
    protected String methodNotFound$str() {
        return methodNotFound;
    }
    @Override
    public final IllegalArgumentException methodNotFound(final String name, final Object args, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), methodNotFound$str(), name, args, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getterNotFound = "WFLYPOJO0033: No such getter: %s on class %s.";
    protected String getterNotFound$str() {
        return getterNotFound;
    }
    @Override
    public final IllegalArgumentException getterNotFound(final Class<?> type, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), getterNotFound$str(), type, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String setterNotFound = "WFLYPOJO0034: No such setter: %s on class %s.";
    protected String setterNotFound$str() {
        return setterNotFound;
    }
    @Override
    public final IllegalArgumentException setterNotFound(final Class<?> type, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), setterNotFound$str(), type, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambiguousMatch1 = "WFLYPOJO0035: Ambiguous match %s.";
    protected String ambiguousMatch1$str() {
        return ambiguousMatch1;
    }
    @Override
    public final IllegalArgumentException ambiguousMatch(final Object info) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ambiguousMatch1$str(), info));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambiguousMatch3 = "WFLYPOJO0036: Ambiguous match of %s for name %s on class %s.";
    protected String ambiguousMatch3$str() {
        return ambiguousMatch3;
    }
    @Override
    public final IllegalArgumentException ambiguousMatch(final Object info, final String name, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), ambiguousMatch3$str(), info, name, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fieldNotFound = "WFLYPOJO0037: Field not found %s for class %s.";
    protected String fieldNotFound$str() {
        return fieldNotFound;
    }
    @Override
    public final IllegalArgumentException fieldNotFound(final String name, final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), fieldNotFound$str(), name, clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parsingException = "WFLYPOJO0038: Exception while parsing POJO descriptor file: %s";
    protected String parsingException$str() {
        return parsingException;
    }
    @Override
    public final DeploymentUnitProcessingException parsingException(final VirtualFile beansXml, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), parsingException$str(), beansXml), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
