/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.embedded.EmbedHostControllerHandler;
import org.jboss.as.cli.embedded.EmbedServerHandler;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.embedded.StopEmbeddedHostControllerHandler;
import org.jboss.as.cli.embedded.StopEmbeddedServerHandler;
import org.jboss.modules.ModuleClassLoader;

public class EmbeddedControllerHandlerRegistrar {
    static final String[] EXTENDED_SYSTEM_PKGS = new String[]{"org.jboss.logging", "org.jboss.logmanager"};
    private static final boolean hasModules;
    private static final boolean modular;

    private static boolean isModular(ClassLoader cl) {
        if (cl instanceof ModuleClassLoader) {
            return true;
        }
        if (cl != null) {
            return EmbeddedControllerHandlerRegistrar.isModular(cl.getParent());
        }
        return false;
    }

    public static final AtomicReference<EmbeddedProcessLaunch> registerEmbeddedCommands(CommandRegistry commandRegistry, CommandContext ctx) throws CommandLineException {
        AtomicReference<EmbeddedProcessLaunch> serverReference = new AtomicReference<EmbeddedProcessLaunch>();
        if (hasModules) {
            commandRegistry.registerHandler((CommandHandler)EmbedServerHandler.create(serverReference, ctx, modular), "embed-server");
            commandRegistry.registerHandler((CommandHandler)new StopEmbeddedServerHandler(serverReference), "stop-embedded-server");
            commandRegistry.registerHandler((CommandHandler)EmbedHostControllerHandler.create(serverReference, ctx, modular), "embed-host-controller");
            commandRegistry.registerHandler((CommandHandler)new StopEmbeddedHostControllerHandler(serverReference), "stop-embedded-host-controller");
        }
        return serverReference;
    }

    static {
        Class<?> clazz = null;
        ClassLoader cl = EmbeddedControllerHandlerRegistrar.class.getClassLoader();
        try {
            String classname = "org.jboss.modules.Module";
            clazz = Class.forName(classname, false, cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        hasModules = clazz != null;
        modular = hasModules ? EmbeddedControllerHandlerRegistrar.isModular(cl) : false;
    }
}

