/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.MessageReader;
import org.jboss.remoting3.remote.RemoteConnectionProvider;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.xnio.Buffers;
import org.xnio.ByteBufferPool;
import org.xnio.ChannelListener;
import org.xnio.Connection;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pooled;
import org.xnio.Result;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.SslChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.sasl.SaslWrapper;

final class RemoteConnection {
    static final Pooled<ByteBuffer> STARTTLS_SENTINEL = Buffers.emptyPooledByteBuffer();
    private static final String FQCN = RemoteConnection.class.getName();
    private final StreamConnection connection;
    private final MessageReader messageReader;
    private final SslChannel sslChannel;
    private final OptionMap optionMap;
    private final RemoteWriteListener writeListener = new RemoteWriteListener();
    private final Executor executor;
    private final int heartbeatInterval;
    private volatile Result<ConnectionHandlerFactory> result;
    private volatile SaslWrapper saslWrapper;
    private volatile SecurityIdentity identity;
    private final RemoteConnectionProvider remoteConnectionProvider;

    RemoteConnection(StreamConnection connection, SslChannel sslChannel, OptionMap optionMap, RemoteConnectionProvider remoteConnectionProvider) {
        this.connection = connection;
        this.messageReader = new MessageReader(connection.getSourceChannel(), this.writeListener.queue);
        this.sslChannel = sslChannel;
        this.optionMap = optionMap;
        this.heartbeatInterval = optionMap.get(RemotingOptions.HEARTBEAT_INTERVAL, 60000);
        Messages.conn.tracef("Initialized connection from %s to %s with options %s", (Object)connection.getPeerAddress(), (Object)connection.getLocalAddress(), (Object)optionMap);
        this.executor = remoteConnectionProvider.getExecutor();
        this.remoteConnectionProvider = remoteConnectionProvider;
    }

    Pooled<ByteBuffer> allocate() {
        return Buffers.globalPooledWrapper(ByteBufferPool.MEDIUM_DIRECT.allocate());
    }

    void setReadListener(ChannelListener<ConduitStreamSourceChannel> listener, boolean resume) {
        Messages.log.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, (Throwable)null, "Setting read listener to %s", (Object)listener);
        this.messageReader.setReadListener(listener);
        if (listener != null && resume) {
            this.messageReader.resumeReads();
        }
    }

    RemoteConnectionProvider getRemoteConnectionProvider() {
        return this.remoteConnectionProvider;
    }

    Result<ConnectionHandlerFactory> getResult() {
        return this.result;
    }

    void setResult(Result<ConnectionHandlerFactory> result) {
        this.result = result;
    }

    void handleException(IOException e) {
        this.handleException(e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(IOException e, boolean log) {
        XnioExecutor.Key key;
        Messages.conn.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, (Throwable)e, "Connection error detail", new Object[0]);
        if (log) {
            Messages.conn.connectionError(e);
        }
        if ((key = this.writeListener.heartKey) != null) {
            key.remove();
        }
        Object object = this.getLock();
        synchronized (object) {
            IoUtils.safeClose((Closeable)this.connection);
        }
        Result<ConnectionHandlerFactory> result = this.result;
        if (result != null) {
            result.setException(e);
            this.result = null;
        }
    }

    void send(Pooled<ByteBuffer> pooled) {
        this.writeListener.send(pooled, false);
    }

    void send(Pooled<ByteBuffer> pooled, boolean close) {
        this.writeListener.send(pooled, close);
    }

    void shutdownWrites() {
        this.writeListener.shutdownWrites();
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    MessageReader getMessageReader() {
        return this.messageReader;
    }

    RemoteWriteListener getWriteListener() {
        return this.writeListener;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public SslChannel getSslChannel() {
        return this.sslChannel;
    }

    SaslWrapper getSaslWrapper() {
        return this.saslWrapper;
    }

    void setSaslWrapper(SaslWrapper saslWrapper) {
        this.saslWrapper = saslWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePreAuthCloseRequest() {
        try {
            this.terminateHeartbeat();
            Object object = this.getLock();
            synchronized (object) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            Messages.conn.debug("Error closing remoting channel", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAlive() {
        Messages.conn.trace("Sending connection alive");
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = pooled.getResource();
            buffer.put((byte)-16);
            buffer.limit(80);
            Buffers.addRandom(buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
            this.messageReader.wakeupReads();
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAliveResponse() {
        Messages.conn.trace("Sending connection alive ack");
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = pooled.getResource();
            buffer.put((byte)-15);
            buffer.limit(80);
            Buffers.addRandom(buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    void terminateHeartbeat() {
        XnioExecutor.Key key = this.writeListener.heartKey;
        if (key != null) {
            key.remove();
        }
    }

    Object getLock() {
        return this.writeListener.queue;
    }

    SecurityIdentity getIdentity() {
        return this.identity;
    }

    void setIdentity(SecurityIdentity identity) {
        this.identity = identity;
    }

    InetSocketAddress getPeerAddress() {
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    Connection getConnection() {
        return this.connection;
    }

    public String toString() {
        return String.format("Remoting connection %08x to %s of %s", this.hashCode(), this.connection.getPeerAddress(), this.getRemoteConnectionProvider().getConnectionProviderContext().getEndpoint());
    }

    final class RemoteWriteListener
    implements ChannelListener<ConduitStreamSinkChannel> {
        private final Queue<Pooled<ByteBuffer>> queue = new ArrayDeque<Pooled<ByteBuffer>>();
        private volatile XnioExecutor.Key heartKey;
        private boolean closed;
        private boolean flushing;
        private ByteBuffer headerBuffer = ByteBuffer.allocateDirect(4);
        private final ByteBuffer[] cachedArray = new ByteBuffer[]{this.headerBuffer, null};
        private volatile long expireTime = -1L;
        private final Runnable flushTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RemoteWriteListener.this.handleEvent(RemoteConnection.this.connection.getSinkChannel());
                if (!RemoteWriteListener.this.queue.isEmpty()) {
                    RemoteConnection.this.connection.getSinkChannel().resumeWrites();
                }
                Queue queue = RemoteWriteListener.this.queue;
                synchronized (queue) {
                    if (RemoteWriteListener.this.closed) {
                        RemoteWriteListener.this.doShutdownWrites();
                    }
                    RemoteWriteListener.this.flushing = false;
                }
            }
        };

        RemoteWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConduitStreamSinkChannel channel) {
            ByteBuffer[] cachedArray = this.cachedArray;
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                block19: {
                    Queue<Pooled<ByteBuffer>> queue2 = this.queue;
                    try {
                        Pooled<ByteBuffer> pooled;
                        ByteBuffer buffer = cachedArray[1];
                        if (buffer != null) {
                            channel.write(cachedArray);
                            if (buffer.hasRemaining()) {
                                return;
                            }
                        }
                        cachedArray[1] = null;
                        while ((pooled = queue2.peek()) != null) {
                            buffer = pooled.getResource();
                            if (buffer.hasRemaining()) {
                                this.headerBuffer.putInt(0, buffer.remaining());
                                this.headerBuffer.position(0);
                                cachedArray[1] = buffer;
                                long res = channel.write(cachedArray);
                                Messages.conn.tracef("Sent %d bytes", res);
                                if (buffer.hasRemaining()) {
                                    return;
                                }
                                cachedArray[1] = null;
                                queue2.poll().free();
                                continue;
                            }
                            if (pooled == STARTTLS_SENTINEL) {
                                if (channel.flush()) {
                                    Messages.conn.trace("Flushed channel");
                                    SslChannel sslChannel = RemoteConnection.this.getSslChannel();
                                    assert (sslChannel != null);
                                    sslChannel.startHandshake();
                                } else {
                                    Messages.conn.trace("Flush stalled");
                                    return;
                                }
                            }
                            queue2.poll().free();
                        }
                        if (!channel.flush()) break block19;
                        Messages.conn.trace("Flushed channel");
                        if (this.closed) {
                            RemoteConnection.this.terminateHeartbeat();
                            channel.shutdownWrites();
                            if (channel.flush()) {
                                Messages.conn.trace("Shut down writes on channel");
                                return;
                            }
                            return;
                        }
                        if (RemoteConnection.this.heartbeatInterval != 0) {
                            this.expireTime = System.currentTimeMillis() + (long)RemoteConnection.this.heartbeatInterval;
                            if (this.heartKey == null) {
                                XnioExecutor executor = channel.getWriteThread();
                                HeartBeat heartBeat = new HeartBeat(executor);
                                this.heartKey = executor.executeAfter(heartBeat, RemoteConnection.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                            }
                        }
                        channel.suspendWrites();
                    }
                    catch (IOException e) {
                        Pooled<ByteBuffer> pooled;
                        RemoteConnection.this.handleException(e, false);
                        while ((pooled = queue2.poll()) != null) {
                            pooled.free();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownWrites() {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                this.closed = true;
                RemoteConnection.this.terminateHeartbeat();
                ConduitStreamSinkChannel sinkChannel = RemoteConnection.this.connection.getSinkChannel();
                if (!this.queue.isEmpty()) {
                    sinkChannel.resumeWrites();
                    return;
                }
                if (!this.flushing) {
                    this.doShutdownWrites();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doShutdownWrites() {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                ConduitStreamSinkChannel sinkChannel = RemoteConnection.this.connection.getSinkChannel();
                try {
                    sinkChannel.shutdownWrites();
                    if (!sinkChannel.flush()) {
                        sinkChannel.resumeWrites();
                        return;
                    }
                    Messages.conn.logf(FQCN, Logger.Level.TRACE, (Throwable)null, "Shut down writes on channel", new Object[0]);
                }
                catch (IOException e) {
                    Pooled<ByteBuffer> unqueued;
                    RemoteConnection.this.handleException(e, false);
                    while ((unqueued = this.queue.poll()) != null) {
                        unqueued.free();
                    }
                }
            }
        }

        public void send(Pooled<ByteBuffer> pooled, boolean close) {
            RemoteConnection.this.connection.getIoThread().execute(() -> {
                Queue<Pooled<ByteBuffer>> queue = this.queue;
                synchronized (queue) {
                    block18: {
                        XnioExecutor.Key heartKey1 = this.heartKey;
                        if (heartKey1 != null) {
                            this.expireTime = System.currentTimeMillis() + (long)RemoteConnection.this.heartbeatInterval;
                        }
                        if (this.closed) {
                            pooled.free();
                            return;
                        }
                        if (close) {
                            this.closed = true;
                        }
                        boolean free = true;
                        try {
                            SaslWrapper wrapper = RemoteConnection.this.saslWrapper;
                            if (wrapper != null) {
                                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                                ByteBuffer source = buffer.duplicate();
                                buffer.clear();
                                wrapper.wrap(buffer, source);
                                buffer.flip();
                            }
                            boolean empty = this.queue.isEmpty();
                            this.queue.add(pooled);
                            free = false;
                            if (!empty) break block18;
                            if (RemoteConnection.this.identity != null) {
                                Queue<Pooled<ByteBuffer>> queue2 = this.queue;
                                synchronized (queue2) {
                                    this.flushing = true;
                                }
                                RemoteConnection.this.connection.getIoThread().execute(this.flushTask);
                                break block18;
                            }
                            RemoteConnection.this.connection.getSinkChannel().resumeWrites();
                        }
                        catch (IOException e) {
                            Pooled<ByteBuffer> unqueued;
                            RemoteConnection.this.handleException(e, false);
                            while ((unqueued = this.queue.poll()) != null) {
                                unqueued.free();
                            }
                        }
                        finally {
                            if (free) {
                                pooled.free();
                            }
                        }
                    }
                }
            });
        }

        private class HeartBeat
        implements Runnable {
            private final XnioExecutor executor;

            public HeartBeat(XnioExecutor executor) {
                this.executor = executor;
            }

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                if (currentTime >= RemoteWriteListener.this.expireTime) {
                    RemoteConnection.this.sendAlive();
                    RemoteWriteListener.this.heartKey = this.executor.executeAfter(this, RemoteConnection.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                } else {
                    long nextBeatInterval = RemoteWriteListener.this.expireTime - System.currentTimeMillis();
                    RemoteWriteListener.this.heartKey = this.executor.executeAfter(this, nextBeatInterval < 0L ? 0L : nextBeatInterval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

