/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.wildfly.naming.client.MarshallingCompatibilityHelper;

final class ProtocolUtils {
    public static final String NAMING = "naming";
    public static final byte[] NAMING_BYTES = new byte[]{110, 97, 109, 105, 110, 103};
    private static MarshallerFactory riverMarshallerFactory = Marshalling.getProvidedMarshallerFactory("river");
    private static final List<MarshallingCompatibilityHelper> MARSHALLING_COMPATIBILITY_HELPERS;

    private ProtocolUtils() {
    }

    public static int readId(MessageInputStream stream, int version) throws IOException {
        return version == 1 ? stream.readInt() : stream.readUnsignedShort();
    }

    public static void writeId(MessageOutputStream stream, int version, int id) throws IOException {
        if (version == 1) {
            stream.writeInt(id);
        } else {
            stream.writeShort(id);
        }
    }

    public static Unmarshaller createUnmarshaller(MessageInputStream is, MarshallingConfiguration configuration) throws IOException {
        Unmarshaller unmarshaller = riverMarshallerFactory.createUnmarshaller(configuration);
        unmarshaller.start(Marshalling.createByteInput(is));
        return unmarshaller;
    }

    public static Marshaller createMarshaller(MessageOutputStream os, MarshallingConfiguration configuration) throws IOException {
        Marshaller marshaller = riverMarshallerFactory.createMarshaller(configuration);
        marshaller.start(new OutputStreamByteOutput(os){

            @Override
            public void flush() throws IOException {
            }
        });
        return marshaller;
    }

    static List<MarshallingCompatibilityHelper> getMarshallingCompatibilityHelpers() {
        return MARSHALLING_COMPATIBILITY_HELPERS;
    }

    static {
        ArrayList<MarshallingCompatibilityHelper> list = new ArrayList<MarshallingCompatibilityHelper>();
        ServiceLoader<MarshallingCompatibilityHelper> helpers = ServiceLoader.load(MarshallingCompatibilityHelper.class, ProtocolUtils.class.getClassLoader());
        Iterator<MarshallingCompatibilityHelper> iterator = helpers.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
        MARSHALLING_COMPATIBILITY_HELPERS = list;
    }
}

